/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonView;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableContentKeyDetails;
import org.projectnessie.model.ImmutableMergeResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.ser.Views;

@Schema(type=SchemaType.OBJECT, title="Merge Response")
@JsonSerialize(as=ImmutableMergeResponse.class)
@JsonDeserialize(as=ImmutableMergeResponse.class)
@Value.Immutable
public interface MergeResponse {
    @Value.Default
    default public boolean wasApplied() {
        return false;
    }

    @Value.Default
    default public boolean wasSuccessful() {
        return false;
    }

    @javax.annotation.Nullable
    @Nullable
    public String getResultantTargetHash();

    @javax.annotation.Nullable
    @Nullable
    public String getCommonAncestor();

    public String getTargetBranch();

    public String getEffectiveTargetHash();

    @javax.annotation.Nullable
    @Nullable
    public String getExpectedHash();

    @Deprecated
    @Schema(deprecated=true, hidden=true)
    @JsonView(value={Views.V1.class})
    public List<LogResponse.LogEntry> getSourceCommits();

    @javax.annotation.Nullable
    @Nullable
    @Deprecated
    @Schema(deprecated=true, hidden=true)
    @JsonView(value={Views.V1.class})
    public List<LogResponse.LogEntry> getTargetCommits();

    public List<ContentKeyDetails> getDetails();

    @Deprecated
    public static enum ContentKeyConflict {
        NONE,
        UNRESOLVABLE;


        public static ContentKeyConflict parse(String mergeBehavior) {
            try {
                if (mergeBehavior != null) {
                    return ContentKeyConflict.valueOf(mergeBehavior.toUpperCase(Locale.ROOT));
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                return UNRESOLVABLE;
            }
        }

        static final class Deserializer
        extends JsonDeserializer<ContentKeyConflict> {
            Deserializer() {
            }

            @Override
            public ContentKeyConflict deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String name = p.readValueAs(String.class);
                return name != null ? ContentKeyConflict.parse(name) : null;
            }
        }
    }

    @Schema(type=SchemaType.OBJECT, title="Merge Per-Content-Key details")
    @JsonSerialize(as=ImmutableContentKeyDetails.class)
    @JsonDeserialize(as=ImmutableContentKeyDetails.class)
    @Value.Immutable
    public static interface ContentKeyDetails {
        public ContentKey getKey();

        public MergeBehavior getMergeBehavior();

        @Deprecated
        @JsonDeserialize(using=ContentKeyConflict.Deserializer.class)
        @Schema(deprecated=true, hidden=true)
        @JsonView(value={Views.V1.class})
        @Value.Default
        default public ContentKeyConflict getConflictType() {
            return ContentKeyConflict.NONE;
        }

        @Deprecated
        @Schema(deprecated=true, hidden=true)
        @JsonView(value={Views.V1.class})
        public List<String> getSourceCommits();

        @Deprecated
        @Schema(deprecated=true, hidden=true)
        @JsonView(value={Views.V1.class})
        public List<String> getTargetCommits();

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonView(value={Views.V2.class})
        @javax.annotation.Nullable
        public Conflict getConflict();
    }
}

