/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.error;

import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import org.projectnessie.error.ContentKeyErrorDetails;
import org.projectnessie.error.GenericErrorDetails;
import org.projectnessie.error.NessieErrorDetails;
import org.projectnessie.error.ReferenceConflicts;

public class NessieErrorDetailsTypeIdResolver
extends TypeIdResolverBase {
    private JavaType baseType;

    @Override
    public void init(JavaType bt) {
        this.baseType = bt;
    }

    @Override
    public String idFromValue(Object value) {
        return this.getId(value);
    }

    @Override
    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return this.getId(value);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    private String getId(Object value) {
        if (value instanceof NessieErrorDetails) {
            return ((NessieErrorDetails)value).getType();
        }
        return null;
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id) {
        Class asType;
        switch (id) {
            case "REFERENCE_CONFLICTS": {
                asType = ReferenceConflicts.class;
                break;
            }
            case "CONTENT_KEY": {
                asType = ContentKeyErrorDetails.class;
                break;
            }
            default: {
                asType = GenericErrorDetails.class;
            }
        }
        if (this.baseType.getRawClass().isAssignableFrom(asType)) {
            return context.constructSpecializedType(this.baseType, asType);
        }
        Class<?> concrete = this.baseType.getRawClass();
        return context.constructSpecializedType(this.baseType, concrete);
    }
}

