/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.DeviceCodeTokenRequest;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.PublicClientRequest;
import org.projectnessie.client.auth.oauth2.TokenRequestBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeviceCodeTokenRequest", generator="Immutables")
@Immutable
final class ImmutableDeviceCodeTokenRequest
implements DeviceCodeTokenRequest {
    @Nullable
    private final String scope;
    @Nullable
    private final String clientId;
    private final transient GrantType grantType;
    private final String deviceCode;

    private ImmutableDeviceCodeTokenRequest(@Nullable String scope, @Nullable String clientId, String deviceCode) {
        this.scope = scope;
        this.clientId = clientId;
        this.deviceCode = deviceCode;
        this.grantType = Objects.requireNonNull(DeviceCodeTokenRequest.super.getGrantType(), "grantType");
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="client_id")
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="grantType")
    public GrantType getGrantType() {
        return this.grantType;
    }

    @Override
    @JsonProperty(value="device_code")
    public String getDeviceCode() {
        return this.deviceCode;
    }

    public final ImmutableDeviceCodeTokenRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableDeviceCodeTokenRequest(value, this.clientId, this.deviceCode);
    }

    public final ImmutableDeviceCodeTokenRequest withClientId(@Nullable String value) {
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutableDeviceCodeTokenRequest(this.scope, value, this.deviceCode);
    }

    public final ImmutableDeviceCodeTokenRequest withDeviceCode(String value) {
        String newValue = Objects.requireNonNull(value, "deviceCode");
        if (this.deviceCode.equals(newValue)) {
            return this;
        }
        return new ImmutableDeviceCodeTokenRequest(this.scope, this.clientId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeviceCodeTokenRequest && this.equalTo(0, (ImmutableDeviceCodeTokenRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeviceCodeTokenRequest another) {
        return Objects.equals(this.scope, another.scope) && Objects.equals(this.clientId, another.clientId) && this.grantType.equals((Object)another.grantType) && this.deviceCode.equals(another.deviceCode);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.scope);
        h2 += (h2 << 5) + Objects.hashCode(this.clientId);
        h2 += (h2 << 5) + this.grantType.hashCode();
        h2 += (h2 << 5) + this.deviceCode.hashCode();
        return h2;
    }

    public String toString() {
        return "DeviceCodeTokenRequest{scope=" + this.scope + ", clientId=" + this.clientId + ", grantType=" + (Object)((Object)this.grantType) + ", deviceCode=" + this.deviceCode + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDeviceCodeTokenRequest fromJson(Json json) {
        Builder builder = ImmutableDeviceCodeTokenRequest.builder();
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.deviceCode != null) {
            builder.deviceCode(json.deviceCode);
        }
        return builder.build();
    }

    public static ImmutableDeviceCodeTokenRequest copyOf(DeviceCodeTokenRequest instance) {
        if (instance instanceof ImmutableDeviceCodeTokenRequest) {
            return (ImmutableDeviceCodeTokenRequest)instance;
        }
        return ImmutableDeviceCodeTokenRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeviceCodeTokenRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements DeviceCodeTokenRequest.Builder {
        private static final long INIT_BIT_DEVICE_CODE = 1L;
        private long initBits = 1L;
        @Nullable
        private String scope;
        @Nullable
        private String clientId;
        @Nullable
        private String deviceCode;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeviceCodeTokenRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PublicClientRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String scopeValue;
            String clientIdValue;
            Object instance;
            long bits = 0L;
            if (object instanceof DeviceCodeTokenRequest) {
                instance = (DeviceCodeTokenRequest)object;
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
                this.deviceCode(instance.getDeviceCode());
            }
            if (object instanceof PublicClientRequest) {
                instance = (PublicClientRequest)object;
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof TokenRequestBase) {
                instance = (TokenRequestBase)object;
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonProperty(value="client_id")
        @CanIgnoreReturnValue
        public final Builder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        @JsonProperty(value="device_code")
        @CanIgnoreReturnValue
        public final Builder deviceCode(String deviceCode) {
            this.deviceCode = Objects.requireNonNull(deviceCode, "deviceCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public ImmutableDeviceCodeTokenRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeviceCodeTokenRequest(this.scope, this.clientId, this.deviceCode);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("deviceCode");
            }
            return "Cannot build DeviceCodeTokenRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DeviceCodeTokenRequest", generator="Immutables")
    static final class Json
    implements DeviceCodeTokenRequest {
        @Nullable
        String scope;
        @Nullable
        String clientId;
        @Nullable
        String deviceCode;

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @JsonProperty(value="client_id")
        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        @JsonProperty(value="device_code")
        public void setDeviceCode(String deviceCode) {
            this.deviceCode = deviceCode;
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public GrantType getGrantType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDeviceCode() {
            throw new UnsupportedOperationException();
        }
    }
}

