/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.AuthorizationCodeTokenRequest;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.PublicClientRequest;
import org.projectnessie.client.auth.oauth2.TokenRequestBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AuthorizationCodeTokenRequest", generator="Immutables")
@Immutable
final class ImmutableAuthorizationCodeTokenRequest
implements AuthorizationCodeTokenRequest {
    @Nullable
    private final String scope;
    @Nullable
    private final String clientId;
    private final transient GrantType grantType;
    private final String code;
    private final String redirectUri;

    private ImmutableAuthorizationCodeTokenRequest(@Nullable String scope, @Nullable String clientId, String code, String redirectUri) {
        this.scope = scope;
        this.clientId = clientId;
        this.code = code;
        this.redirectUri = redirectUri;
        this.grantType = Objects.requireNonNull(AuthorizationCodeTokenRequest.super.getGrantType(), "grantType");
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="client_id")
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="grantType")
    public GrantType getGrantType() {
        return this.grantType;
    }

    @Override
    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    @Override
    @JsonProperty(value="redirect_uri")
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public final ImmutableAuthorizationCodeTokenRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableAuthorizationCodeTokenRequest(value, this.clientId, this.code, this.redirectUri);
    }

    public final ImmutableAuthorizationCodeTokenRequest withClientId(@Nullable String value) {
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutableAuthorizationCodeTokenRequest(this.scope, value, this.code, this.redirectUri);
    }

    public final ImmutableAuthorizationCodeTokenRequest withCode(String value) {
        String newValue = Objects.requireNonNull(value, "code");
        if (this.code.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorizationCodeTokenRequest(this.scope, this.clientId, newValue, this.redirectUri);
    }

    public final ImmutableAuthorizationCodeTokenRequest withRedirectUri(String value) {
        String newValue = Objects.requireNonNull(value, "redirectUri");
        if (this.redirectUri.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorizationCodeTokenRequest(this.scope, this.clientId, this.code, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthorizationCodeTokenRequest && this.equalTo(0, (ImmutableAuthorizationCodeTokenRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthorizationCodeTokenRequest another) {
        return Objects.equals(this.scope, another.scope) && Objects.equals(this.clientId, another.clientId) && this.grantType.equals((Object)another.grantType) && this.code.equals(another.code) && this.redirectUri.equals(another.redirectUri);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.scope);
        h2 += (h2 << 5) + Objects.hashCode(this.clientId);
        h2 += (h2 << 5) + this.grantType.hashCode();
        h2 += (h2 << 5) + this.code.hashCode();
        h2 += (h2 << 5) + this.redirectUri.hashCode();
        return h2;
    }

    public String toString() {
        return "AuthorizationCodeTokenRequest{scope=" + this.scope + ", clientId=" + this.clientId + ", grantType=" + (Object)((Object)this.grantType) + ", code=" + this.code + ", redirectUri=" + this.redirectUri + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAuthorizationCodeTokenRequest fromJson(Json json) {
        Builder builder = ImmutableAuthorizationCodeTokenRequest.builder();
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.code != null) {
            builder.code(json.code);
        }
        if (json.redirectUri != null) {
            builder.redirectUri(json.redirectUri);
        }
        return builder.build();
    }

    public static ImmutableAuthorizationCodeTokenRequest copyOf(AuthorizationCodeTokenRequest instance) {
        if (instance instanceof ImmutableAuthorizationCodeTokenRequest) {
            return (ImmutableAuthorizationCodeTokenRequest)instance;
        }
        return ImmutableAuthorizationCodeTokenRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuthorizationCodeTokenRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements AuthorizationCodeTokenRequest.Builder {
        private static final long INIT_BIT_CODE = 1L;
        private static final long INIT_BIT_REDIRECT_URI = 2L;
        private long initBits = 3L;
        @Nullable
        private String scope;
        @Nullable
        private String clientId;
        @Nullable
        private String code;
        @Nullable
        private String redirectUri;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AuthorizationCodeTokenRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PublicClientRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String scopeValue;
            String clientIdValue;
            Object instance;
            long bits = 0L;
            if (object instanceof AuthorizationCodeTokenRequest) {
                instance = (AuthorizationCodeTokenRequest)object;
                this.redirectUri(instance.getRedirectUri());
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
                this.code(instance.getCode());
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof PublicClientRequest) {
                instance = (PublicClientRequest)object;
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof TokenRequestBase) {
                instance = (TokenRequestBase)object;
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonProperty(value="client_id")
        @CanIgnoreReturnValue
        public final Builder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        @JsonProperty(value="code")
        @CanIgnoreReturnValue
        public final Builder code(String code) {
            this.code = Objects.requireNonNull(code, "code");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="redirect_uri")
        @CanIgnoreReturnValue
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = Objects.requireNonNull(redirectUri, "redirectUri");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableAuthorizationCodeTokenRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthorizationCodeTokenRequest(this.scope, this.clientId, this.code, this.redirectUri);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("code");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("redirectUri");
            }
            return "Cannot build AuthorizationCodeTokenRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AuthorizationCodeTokenRequest", generator="Immutables")
    static final class Json
    implements AuthorizationCodeTokenRequest {
        @Nullable
        String scope;
        @Nullable
        String clientId;
        @Nullable
        String code;
        @Nullable
        String redirectUri;

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @JsonProperty(value="client_id")
        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        @JsonProperty(value="code")
        public void setCode(String code) {
            this.code = code;
        }

        @JsonProperty(value="redirect_uri")
        public void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public GrantType getGrantType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRedirectUri() {
            throw new UnsupportedOperationException();
        }
    }
}

