/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.projectnessie.client.api.NessieApi;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.auth.NessieAuthenticationProvider;
import org.projectnessie.client.config.NessieClientConfigSource;
import org.projectnessie.client.config.NessieClientConfigSources;

public interface NessieClientBuilder {
    public String name();

    default public Set<String> names() {
        return Collections.singleton(this.name());
    }

    public int priority();

    public <I extends NessieClientBuilder> I asInstanceOf(Class<I> var1);

    @CanIgnoreReturnValue
    public NessieClientBuilder withApiCompatibilityCheck(boolean var1);

    @Deprecated
    @CanIgnoreReturnValue
    public NessieClientBuilder fromSystemProperties();

    @CanIgnoreReturnValue
    public NessieClientBuilder fromConfig(Function<String, String> var1);

    @CanIgnoreReturnValue
    public NessieClientBuilder withAuthenticationFromConfig(Function<String, String> var1);

    @CanIgnoreReturnValue
    public NessieClientBuilder withAuthentication(NessieAuthentication var1);

    @CanIgnoreReturnValue
    public NessieClientBuilder withTracing(boolean var1);

    @CanIgnoreReturnValue
    public NessieClientBuilder withUri(URI var1);

    @CanIgnoreReturnValue
    public NessieClientBuilder withUri(String var1);

    @CanIgnoreReturnValue
    public NessieClientBuilder withReadTimeout(int var1);

    @CanIgnoreReturnValue
    public NessieClientBuilder withConnectionTimeout(int var1);

    @CanIgnoreReturnValue
    public NessieClientBuilder withDisableCompression(boolean var1);

    @CanIgnoreReturnValue
    public NessieClientBuilder withSSLCertificateVerificationDisabled(boolean var1);

    @CanIgnoreReturnValue
    public NessieClientBuilder withSSLContext(SSLContext var1);

    @CanIgnoreReturnValue
    public NessieClientBuilder withSSLParameters(SSLParameters var1);

    @CanIgnoreReturnValue
    public NessieClientBuilder withCancellationFuture(CompletionStage<?> var1);

    public <API extends NessieApi> API build(Class<API> var1);

    public static NessieClientBuilder createClientBuilderFromSystemSettings() {
        return NessieClientBuilder.createClientBuilderFromSystemSettings(NessieClientConfigSources.emptyConfigSource());
    }

    public static NessieClientBuilder createClientBuilderFromSystemSettings(NessieClientConfigSource mainConfigSource) {
        NessieClientConfigSource configSource = mainConfigSource.fallbackTo(NessieClientConfigSources.defaultConfigSources());
        String clientName = configSource.getValue("nessie.client-builder-name");
        String clientBuilderImpl = configSource.getValue("nessie.client-builder-impl");
        return NessieClientBuilder.createClientBuilder(clientName, clientBuilderImpl).fromConfig(configSource.asFunction());
    }

    @javax.annotation.Nonnull
    @Nonnull
    public static NessieClientBuilder createClientBuilder(String clientName, String clientBuilderImpl) {
        ServiceLoader<NessieClientBuilder> implementations = ServiceLoader.load(NessieClientBuilder.class);
        ArrayList<NessieClientBuilder> builders = new ArrayList<NessieClientBuilder>();
        for (NessieClientBuilder clientBuilder : implementations) {
            builders.add(clientBuilder);
            if (clientBuilder.names().contains(clientName)) {
                if (clientBuilderImpl != null && !clientBuilderImpl.isEmpty() && !clientBuilder.getClass().getName().equals(clientBuilderImpl)) {
                    throw new IllegalArgumentException("Requested client named " + clientName + " does not match requested client builder implementation " + clientBuilderImpl);
                }
                return clientBuilder;
            }
            if (!clientBuilder.getClass().getName().equals(clientBuilderImpl)) continue;
            if (clientName != null && !clientName.isEmpty()) {
                throw new IllegalArgumentException("Requested client builder implementation " + clientBuilderImpl + " does not match requested client named " + clientName);
            }
            return clientBuilder;
        }
        if (clientBuilderImpl != null && clientName == null) {
            try {
                return (NessieClientBuilder)Class.forName(clientBuilderImpl).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot load Nessie client builder implementation class", e);
            }
        }
        if (clientBuilderImpl != null || clientName != null) {
            String msg = "Requested Nessie client";
            msg = msg + " named " + clientName;
            if (clientBuilderImpl != null) {
                msg = msg + " or builder implementation class " + clientBuilderImpl;
            }
            throw new IllegalArgumentException(msg + " not found.");
        }
        builders.sort(Comparator.comparingInt(NessieClientBuilder::priority));
        if (builders.isEmpty()) {
            throw new IllegalStateException("No implementation of " + NessieClientBuilder.class.getName() + " available");
        }
        return (NessieClientBuilder)builders.get(builders.size() - 1);
    }

    public static abstract class AbstractNessieClientBuilder
    implements NessieClientBuilder {
        @Override
        @Deprecated
        public NessieClientBuilder fromSystemProperties() {
            return this.fromConfig(NessieClientConfigSources.systemPropertiesConfigSource().asFunction());
        }

        @Override
        public NessieClientBuilder fromConfig(Function<String, String> configuration) {
            String uri = configuration.apply("nessie.uri");
            if (uri != null) {
                this.withUri(URI.create(uri));
            }
            this.withAuthenticationFromConfig(configuration);
            String s2 = configuration.apply("nessie.tracing");
            if (s2 != null) {
                this.withTracing(Boolean.parseBoolean(s2));
            }
            if ((s2 = configuration.apply("nessie.transport.connect-timeout")) != null) {
                this.withConnectionTimeout(Integer.parseInt(s2));
            }
            if ((s2 = configuration.apply("nessie.transport.read-timeout")) != null) {
                this.withReadTimeout(Integer.parseInt(s2));
            }
            if ((s2 = configuration.apply("nessie.transport.disable-compression")) != null) {
                this.withDisableCompression(Boolean.parseBoolean(s2));
            }
            if ((s2 = configuration.apply("nessie.ssl.no-certificate-verification")) != null) {
                this.withSSLCertificateVerificationDisabled(Boolean.parseBoolean(s2));
            }
            SSLParameters sslParameters = new SSLParameters();
            boolean hasSslParameters = false;
            s2 = configuration.apply("nessie.ssl.cipher-suites");
            if (s2 != null) {
                hasSslParameters = true;
                sslParameters.setCipherSuites((String[])Arrays.stream(s2.split(",")).map(String::trim).filter(v -> !v.isEmpty()).toArray(String[]::new));
            }
            if ((s2 = configuration.apply("nessie.ssl.protocols")) != null) {
                hasSslParameters = true;
                sslParameters.setProtocols((String[])Arrays.stream(s2.split(",")).map(String::trim).filter(v -> !v.isEmpty()).toArray(String[]::new));
            }
            if ((s2 = configuration.apply("nessie.ssl.sni-hosts")) != null) {
                hasSslParameters = true;
                sslParameters.setServerNames(Arrays.stream(s2.split(",")).map(String::trim).filter(v -> !v.isEmpty()).map(SNIHostName::new).collect(Collectors.toList()));
            }
            if ((s2 = configuration.apply("nessie.ssl.sni-matcher")) != null) {
                hasSslParameters = true;
                sslParameters.setSNIMatchers(Collections.singletonList(SNIHostName.createSNIMatcher(s2)));
            }
            if (hasSslParameters) {
                this.withSSLParameters(sslParameters);
            }
            if ((s2 = configuration.apply("nessie.enable-api-compatibility-check")) != null) {
                this.withApiCompatibilityCheck(Boolean.parseBoolean(s2));
            }
            return this;
        }

        @Override
        public NessieClientBuilder withAuthenticationFromConfig(Function<String, String> configuration) {
            this.withAuthentication(NessieAuthenticationProvider.fromConfig(configuration));
            return this;
        }

        @Override
        public NessieClientBuilder withUri(String uri) {
            return this.withUri(URI.create(uri));
        }

        @Override
        public <I extends NessieClientBuilder> I asInstanceOf(Class<I> builderInterfaceType) {
            return (I)((NessieClientBuilder)builderInterfaceType.cast(this));
        }

        @Override
        public NessieClientBuilder withApiCompatibilityCheck(boolean enable) {
            return this;
        }

        @Override
        public NessieClientBuilder withAuthentication(NessieAuthentication authentication) {
            return this;
        }

        @Override
        public NessieClientBuilder withTracing(boolean tracing) {
            return this;
        }

        @Override
        public NessieClientBuilder withUri(URI uri) {
            return this;
        }

        @Override
        public NessieClientBuilder withReadTimeout(int readTimeoutMillis) {
            return this;
        }

        @Override
        public NessieClientBuilder withConnectionTimeout(int connectionTimeoutMillis) {
            return this;
        }

        @Override
        public NessieClientBuilder withDisableCompression(boolean disableCompression) {
            return this;
        }

        @Override
        public NessieClientBuilder withSSLCertificateVerificationDisabled(boolean certificateVerificationDisabled) {
            return this;
        }

        @Override
        public NessieClientBuilder withSSLContext(SSLContext sslContext) {
            return this;
        }

        @Override
        public NessieClientBuilder withSSLParameters(SSLParameters sslParameters) {
            return this;
        }

        @Override
        public NessieClientBuilder withCancellationFuture(CompletionStage<?> cancellationFuture) {
            return this;
        }
    }
}

