/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v1.params;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.ws.rs.PathParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.v1.params.DiffParamsBuilder;

public class DiffParams {
    public static final String HASH_OPTIONAL_REGEX = "(^[0-9a-fA-F]{8,64}$)?";
    private static final char HASH_SEPARATOR = '*';
    @javax.validation.constraints.Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    private @javax.validation.constraints.Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String fromRef;
    @Nullable
    @jakarta.annotation.Nullable
    @javax.validation.constraints.Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes")
    @Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes")
    private @javax.validation.constraints.Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes") @Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes") String fromHashOnRef;
    @javax.validation.constraints.Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    private @javax.validation.constraints.Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String toRef;
    @Nullable
    @jakarta.annotation.Nullable
    @javax.validation.constraints.Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes")
    @Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes")
    private @javax.validation.constraints.Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes") @Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes") String toHashOnRef;
    @Parameter(description="The 'from' reference (and optional hash) to start the diff from", examples={@ExampleObject(ref="ref"), @ExampleObject(ref="refForDiffWithHash")})
    @PathParam(value="fromRefWithHash")
    @jakarta.ws.rs.PathParam(value="fromRefWithHash")
    private String fromRefWithHash;
    @Parameter(description="The 'to' reference (and optional hash) to end the diff at.", examples={@ExampleObject(ref="ref"), @ExampleObject(ref="refForDiffWithHash")})
    @PathParam(value="toRefWithHash")
    @jakarta.ws.rs.PathParam(value="toRefWithHash")
    private String toRefWithHash;

    public DiffParams() {
    }

    DiffParams(String fromRefWithHash, String toRefWithHash) {
        this.fromRefWithHash = fromRefWithHash;
        this.toRefWithHash = toRefWithHash;
    }

    @Builder.Constructor
    DiffParams(@javax.validation.constraints.NotNull @NotNull String fromRef, @Nullable @jakarta.annotation.Nullable String fromHashOnRef, @javax.validation.constraints.NotNull @NotNull String toRef, @Nullable @jakarta.annotation.Nullable String toHashOnRef) {
        this.fromRef = fromRef;
        this.fromHashOnRef = fromHashOnRef;
        this.toRef = toRef;
        this.toHashOnRef = toHashOnRef;
    }

    private String parseRefName(String param) {
        int idx = param.indexOf(42);
        return idx == 0 ? null : (idx < 0 ? param : param.substring(0, idx));
    }

    private String parseHash(String param) {
        int idx = param.indexOf(42);
        return idx < 0 ? null : param.substring(idx + 1);
    }

    public String getFromRef() {
        if (this.fromRefWithHash != null) {
            this.fromRef = this.parseRefName(this.fromRefWithHash);
            this.fromHashOnRef = this.parseHash(this.fromRefWithHash);
            this.fromRefWithHash = null;
        }
        return this.fromRef;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public String getFromHashOnRef() {
        if (this.fromRefWithHash != null) {
            this.fromRef = this.parseRefName(this.fromRefWithHash);
            this.fromHashOnRef = this.parseHash(this.fromRefWithHash);
            this.fromRefWithHash = null;
        }
        return DiffParams.emptyToNull(this.fromHashOnRef);
    }

    public String getToRef() {
        if (this.toRefWithHash != null) {
            this.toRef = this.parseRefName(this.toRefWithHash);
            this.toHashOnRef = this.parseHash(this.toRefWithHash);
            this.toRefWithHash = null;
        }
        return this.toRef;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public String getToHashOnRef() {
        if (this.toRefWithHash != null) {
            this.toRef = this.parseRefName(this.toRefWithHash);
            this.toHashOnRef = this.parseHash(this.toRefWithHash);
            this.toRefWithHash = null;
        }
        return DiffParams.emptyToNull(this.toHashOnRef);
    }

    private static String emptyToNull(String s2) {
        if (s2 == null || s2.isEmpty()) {
            return null;
        }
        if (s2.charAt(0) == '*') {
            if (s2.length() == 1) {
                return null;
            }
            return s2.substring(1);
        }
        return s2;
    }

    public static DiffParamsBuilder builder() {
        return new DiffParamsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiffParams)) {
            return false;
        }
        DiffParams that = (DiffParams)o;
        return Objects.equals(this.fromRef, that.fromRef) && Objects.equals(this.fromHashOnRef, that.fromHashOnRef) && Objects.equals(this.toRef, that.toRef) && Objects.equals(this.toHashOnRef, that.toHashOnRef);
    }

    public int hashCode() {
        return Objects.hash(this.fromRef, this.fromHashOnRef, this.toRef, this.toHashOnRef);
    }
}

