/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.filter2.recordlevel;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.predicate.Operators;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicateBuilderBase;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.iceberg.shaded.org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.Binary;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveComparator;

public class IncrementallyUpdatedFilterPredicateBuilder
extends IncrementallyUpdatedFilterPredicateBuilderBase {
    public IncrementallyUpdatedFilterPredicateBuilder(List<PrimitiveColumnIO> leaves) {
        super(leaves);
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.Eq<T> pred) {
        PrimitiveComparator comparator;
        PrimitiveComparator comparator2;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(false);
                    }
                };
            } else {
                final int n = (Integer)pred.getValue();
                final PrimitiveComparator comparator22 = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(comparator22.compare(value, n) == 0);
                    }
                };
            }
        }
        if (clazz.equals(Long.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(false);
                    }
                };
            } else {
                final long l = (Long)pred.getValue();
                comparator2 = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(comparator2.compare(value, l) == 0);
                    }
                };
            }
        }
        if (clazz.equals(Boolean.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(false);
                    }
                };
            } else {
                final boolean bl = (Boolean)pred.getValue();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(comparator.compare(value, bl) == 0);
                    }
                };
            }
        }
        if (clazz.equals(Float.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(false);
                    }
                };
            } else {
                final float f = ((Float)pred.getValue()).floatValue();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(comparator.compare(value, f) == 0);
                    }
                };
            }
        }
        if (clazz.equals(Double.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(false);
                    }
                };
            } else {
                final double d = (Double)pred.getValue();
                comparator2 = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(comparator2.compare(value, d) == 0);
                    }
                };
            }
        }
        if (clazz.equals(Binary.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(false);
                    }
                };
            } else {
                final Binary binary = (Binary)pred.getValue();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(comparator.compare(value, binary) == 0);
                    }
                };
            }
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.NotEq<T> pred) {
        PrimitiveComparator comparator;
        PrimitiveComparator comparator2;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(true);
                    }
                };
            } else {
                final int n = (Integer)pred.getValue();
                final PrimitiveComparator comparator22 = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(comparator22.compare(value, n) != 0);
                    }
                };
            }
        }
        if (clazz.equals(Long.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(true);
                    }
                };
            } else {
                final long l = (Long)pred.getValue();
                comparator2 = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(comparator2.compare(value, l) != 0);
                    }
                };
            }
        }
        if (clazz.equals(Boolean.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(true);
                    }
                };
            } else {
                final boolean bl = (Boolean)pred.getValue();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(comparator.compare(value, bl) != 0);
                    }
                };
            }
        }
        if (clazz.equals(Float.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(true);
                    }
                };
            } else {
                final float f = ((Float)pred.getValue()).floatValue();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(comparator.compare(value, f) != 0);
                    }
                };
            }
        }
        if (clazz.equals(Double.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(true);
                    }
                };
            } else {
                final double d = (Double)pred.getValue();
                comparator2 = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(comparator2.compare(value, d) != 0);
                    }
                };
            }
        }
        if (clazz.equals(Binary.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(true);
                    }
                };
            } else {
                final Binary binary = (Binary)pred.getValue();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(comparator.compare(value, binary) != 0);
                    }
                };
            }
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.In<T> pred) {
        PrimitiveComparator comparator;
        Set target;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(false);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        boolean set = false;
                        Iterator iterator = target.iterator();
                        while (iterator.hasNext()) {
                            int i = (Integer)iterator.next();
                            if (comparator.compare(value, i) != 0) continue;
                            this.setResult(true);
                            set = true;
                            break;
                        }
                        if (!set) {
                            this.setResult(false);
                        }
                    }
                };
            }
        }
        if (clazz.equals(Long.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(false);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        boolean set = false;
                        Iterator iterator = target.iterator();
                        while (iterator.hasNext()) {
                            long i = (Long)iterator.next();
                            if (comparator.compare(value, i) != 0) continue;
                            this.setResult(true);
                            set = true;
                            break;
                        }
                        if (!set) {
                            this.setResult(false);
                        }
                    }
                };
            }
        }
        if (clazz.equals(Boolean.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(false);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(boolean value) {
                        boolean set = false;
                        Iterator iterator = target.iterator();
                        while (iterator.hasNext()) {
                            boolean i = (Boolean)iterator.next();
                            if (comparator.compare(value, i) != 0) continue;
                            this.setResult(true);
                            set = true;
                            break;
                        }
                        if (!set) {
                            this.setResult(false);
                        }
                    }
                };
            }
        }
        if (clazz.equals(Float.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(false);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        boolean set = false;
                        Iterator iterator = target.iterator();
                        while (iterator.hasNext()) {
                            float i = ((Float)iterator.next()).floatValue();
                            if (comparator.compare(value, i) != 0) continue;
                            this.setResult(true);
                            set = true;
                            break;
                        }
                        if (!set) {
                            this.setResult(false);
                        }
                    }
                };
            }
        }
        if (clazz.equals(Double.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(false);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        boolean set = false;
                        Iterator iterator = target.iterator();
                        while (iterator.hasNext()) {
                            double i = (Double)iterator.next();
                            if (comparator.compare(value, i) != 0) continue;
                            this.setResult(true);
                            set = true;
                            break;
                        }
                        if (!set) {
                            this.setResult(false);
                        }
                    }
                };
            }
        }
        if (clazz.equals(Binary.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(false);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        boolean set = false;
                        for (Binary i : target) {
                            if (comparator.compare(value, i) != 0) continue;
                            this.setResult(true);
                            set = true;
                            break;
                        }
                        if (!set) {
                            this.setResult(false);
                        }
                    }
                };
            }
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.NotIn<T> pred) {
        PrimitiveComparator comparator;
        Set target;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(true);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(int value) {
                        boolean set = false;
                        Iterator iterator = target.iterator();
                        while (iterator.hasNext()) {
                            int i = (Integer)iterator.next();
                            if (comparator.compare(value, i) == 0) continue;
                            this.setResult(true);
                            set = true;
                            break;
                        }
                        if (!set) {
                            this.setResult(false);
                        }
                    }
                };
            }
        }
        if (clazz.equals(Long.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(true);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(long value) {
                        boolean set = false;
                        Iterator iterator = target.iterator();
                        while (iterator.hasNext()) {
                            long i = (Long)iterator.next();
                            if (comparator.compare(value, i) == 0) continue;
                            this.setResult(true);
                            set = true;
                            break;
                        }
                        if (!set) {
                            this.setResult(false);
                        }
                    }
                };
            }
        }
        if (clazz.equals(Boolean.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(true);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(boolean value) {
                        boolean set = false;
                        Iterator iterator = target.iterator();
                        while (iterator.hasNext()) {
                            boolean i = (Boolean)iterator.next();
                            if (comparator.compare(value, i) == 0) continue;
                            this.setResult(true);
                            set = true;
                            break;
                        }
                        if (!set) {
                            this.setResult(false);
                        }
                    }
                };
            }
        }
        if (clazz.equals(Float.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(true);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(float value) {
                        boolean set = false;
                        Iterator iterator = target.iterator();
                        while (iterator.hasNext()) {
                            float i = ((Float)iterator.next()).floatValue();
                            if (comparator.compare(value, i) == 0) continue;
                            this.setResult(true);
                            set = true;
                            break;
                        }
                        if (!set) {
                            this.setResult(false);
                        }
                    }
                };
            }
        }
        if (clazz.equals(Double.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(true);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(double value) {
                        boolean set = false;
                        Iterator iterator = target.iterator();
                        while (iterator.hasNext()) {
                            double i = (Double)iterator.next();
                            if (comparator.compare(value, i) == 0) continue;
                            this.setResult(true);
                            set = true;
                            break;
                        }
                        if (!set) {
                            this.setResult(false);
                        }
                    }
                };
            }
        }
        if (clazz.equals(Binary.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(true);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(Binary value) {
                        boolean set = false;
                        for (Binary i : target) {
                            if (comparator.compare(value, i) == 0) continue;
                            this.setResult(true);
                            set = true;
                            break;
                        }
                        if (!set) {
                            this.setResult(false);
                        }
                    }
                };
            }
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.Lt<T> pred) {
        PrimitiveComparator comparator;
        PrimitiveComparator comparator2;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value) {
                    this.setResult(comparator2.compare(value, target) < 0);
                }
            };
        }
        if (clazz.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value) {
                    this.setResult(comparator.compare(value, target) < 0);
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator < not supported for Boolean");
        }
        if (clazz.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value) {
                    this.setResult(comparator2.compare(value, target) < 0);
                }
            };
        }
        if (clazz.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value) {
                    this.setResult(comparator.compare(value, target) < 0);
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value) {
                    this.setResult(comparator2.compare(value, target) < 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.LtEq<T> pred) {
        PrimitiveComparator comparator;
        PrimitiveComparator comparator2;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value) {
                    this.setResult(comparator2.compare(value, target) <= 0);
                }
            };
        }
        if (clazz.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value) {
                    this.setResult(comparator.compare(value, target) <= 0);
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator <= not supported for Boolean");
        }
        if (clazz.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value) {
                    this.setResult(comparator2.compare(value, target) <= 0);
                }
            };
        }
        if (clazz.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value) {
                    this.setResult(comparator.compare(value, target) <= 0);
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value) {
                    this.setResult(comparator2.compare(value, target) <= 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.Gt<T> pred) {
        PrimitiveComparator comparator;
        PrimitiveComparator comparator2;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value) {
                    this.setResult(comparator2.compare(value, target) > 0);
                }
            };
        }
        if (clazz.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value) {
                    this.setResult(comparator.compare(value, target) > 0);
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator > not supported for Boolean");
        }
        if (clazz.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value) {
                    this.setResult(comparator2.compare(value, target) > 0);
                }
            };
        }
        if (clazz.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value) {
                    this.setResult(comparator.compare(value, target) > 0);
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value) {
                    this.setResult(comparator2.compare(value, target) > 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.GtEq<T> pred) {
        PrimitiveComparator comparator;
        PrimitiveComparator comparator2;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value) {
                    this.setResult(comparator2.compare(value, target) >= 0);
                }
            };
        }
        if (clazz.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value) {
                    this.setResult(comparator.compare(value, target) >= 0);
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator >= not supported for Boolean");
        }
        if (clazz.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value) {
                    this.setResult(comparator2.compare(value, target) >= 0);
                }
            };
        }
        if (clazz.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value) {
                    this.setResult(comparator.compare(value, target) >= 0);
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value) {
                    this.setResult(comparator2.compare(value, target) >= 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(Operators.UserDefined<T, U> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class<T> clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        U udp = pred.getUserDefinedPredicate();
        if (clazz.equals(Integer.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(int value) {
                    this.setResult(this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Long.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(long value) {
                    this.setResult(this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(boolean value) {
                    this.setResult(this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Float.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(float value) {
                    this.setResult(this.val$udp.keep((Comparable)Float.valueOf(value)));
                }
            };
        }
        if (clazz.equals(Double.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(double value) {
                    this.setResult(this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(Binary value) {
                    this.setResult(this.val$udp.keep((Comparable)value));
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(Operators.LogicalNotUserDefined<T, U> notPred) {
        Operators.UserDefined<T, U> pred = notPred.getUserDefined();
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class<T> clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        U udp = pred.getUserDefinedPredicate();
        if (clazz.equals(Integer.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(int value) {
                    this.setResult(!this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Long.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(long value) {
                    this.setResult(!this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(boolean value) {
                    this.setResult(!this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Float.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(float value) {
                    this.setResult(!this.val$udp.keep((Comparable)Float.valueOf(value)));
                }
            };
        }
        if (clazz.equals(Double.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(double value) {
                    this.setResult(!this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(Binary value) {
                    this.setResult(!this.val$udp.keep((Comparable)value));
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }
}

