/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.column;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnPath;

abstract class ColumnProperty<T> {
    ColumnProperty() {
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(ColumnProperty<T> toCopy) {
        Builder<Object> builder = new Builder<Object>();
        builder.withDefaultValue(((DefaultColumnProperty)toCopy).defaultValue);
        if (toCopy instanceof MultipleColumnProperty) {
            ((Builder)builder).values.putAll(((MultipleColumnProperty)toCopy).values);
        }
        return builder;
    }

    public abstract T getDefaultValue();

    public abstract T getValue(ColumnPath var1);

    public T getValue(String columnPath) {
        return this.getValue(ColumnPath.fromDotString(columnPath));
    }

    public T getValue(ColumnDescriptor columnDescriptor) {
        return this.getValue(ColumnPath.get(columnDescriptor.getPath()));
    }

    static class Builder<T> {
        private T defaultValue;
        private final Map<ColumnPath, T> values = new HashMap<ColumnPath, T>();

        private Builder() {
        }

        public Builder<T> withDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder<T> withValue(ColumnPath columnPath, T value) {
            this.values.put(columnPath, value);
            return this;
        }

        public Builder<T> withValue(String columnPath, T value) {
            return this.withValue(ColumnPath.fromDotString(columnPath), value);
        }

        public Builder<T> withValue(ColumnDescriptor columnDescriptor, T value) {
            return this.withValue(ColumnPath.get(columnDescriptor.getPath()), value);
        }

        public ColumnProperty<T> build() {
            if (this.values.isEmpty()) {
                return new DefaultColumnProperty(this.defaultValue);
            }
            return new MultipleColumnProperty(this.defaultValue, this.values);
        }
    }

    private static class MultipleColumnProperty<T>
    extends DefaultColumnProperty<T> {
        private final Map<ColumnPath, T> values;

        private MultipleColumnProperty(T defaultValue, Map<ColumnPath, T> values) {
            super(defaultValue);
            assert (!values.isEmpty());
            this.values = new HashMap<ColumnPath, T>(values);
        }

        @Override
        public T getValue(ColumnPath columnPath) {
            T value = this.values.get(columnPath);
            if (value != null) {
                return value;
            }
            return this.getDefaultValue();
        }

        @Override
        public String toString() {
            return Objects.toString(this.getDefaultValue()) + ' ' + this.values.toString();
        }
    }

    private static class DefaultColumnProperty<T>
    extends ColumnProperty<T> {
        private final T defaultValue;

        private DefaultColumnProperty(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public T getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public T getValue(ColumnPath columnPath) {
            return this.getDefaultValue();
        }

        public String toString() {
            return Objects.toString(this.getDefaultValue());
        }
    }
}

