/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.iceberg.UpdateRequirements;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.ErrorHandlers;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewOperations;

class RESTViewOperations
implements ViewOperations {
    private final RESTClient client;
    private final String path;
    private final Supplier<Map<String, String>> headers;
    private ViewMetadata current;

    RESTViewOperations(RESTClient client, String path, Supplier<Map<String, String>> headers, ViewMetadata current) {
        Preconditions.checkArgument(null != current, "Invalid view metadata: null");
        this.client = client;
        this.path = path;
        this.headers = headers;
        this.current = current;
    }

    @Override
    public ViewMetadata current() {
        return this.current;
    }

    @Override
    public ViewMetadata refresh() {
        return this.updateCurrentMetadata(this.client.get(this.path, LoadViewResponse.class, this.headers, ErrorHandlers.viewErrorHandler()));
    }

    @Override
    public void commit(ViewMetadata base, ViewMetadata metadata) {
        Preconditions.checkState(base != null, "Invalid base metadata: null");
        UpdateTableRequest request = UpdateTableRequest.create(null, UpdateRequirements.forReplaceView(base, metadata.changes()), metadata.changes());
        LoadViewResponse response = this.client.post(this.path, (RESTRequest)request, LoadViewResponse.class, this.headers, ErrorHandlers.viewCommitHandler());
        this.updateCurrentMetadata(response);
    }

    private ViewMetadata updateCurrentMetadata(LoadViewResponse response) {
        if (!Objects.equals(this.current.metadataFileLocation(), response.metadataLocation())) {
            this.current = response.metadata();
        }
        return this.current;
    }
}

