/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.UUIDConversion;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.avro.Conversion;
import org.apache.iceberg.shaded.org.apache.avro.Conversions;
import org.apache.iceberg.shaded.org.apache.avro.LogicalType;
import org.apache.iceberg.shaded.org.apache.avro.LogicalTypes;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.generic.GenericData;
import org.apache.iceberg.shaded.org.apache.avro.generic.GenericFixed;
import org.apache.iceberg.shaded.org.apache.avro.specific.SpecificData;
import org.apache.iceberg.types.TypeUtil;

class ParquetAvro {
    static final GenericData DEFAULT_MODEL;

    private ParquetAvro() {
    }

    static Schema parquetAvroSchema(Schema avroSchema) {
        return AvroSchemaVisitor.visit(avroSchema, new ParquetDecimalSchemaConverter());
    }

    static {
        LogicalTypes.register("parquet-decimal", schema -> {
            int precision = Integer.parseInt(schema.getProp("precision"));
            int scale = Integer.parseInt(schema.getProp("scale"));
            return new ParquetDecimal(precision, scale);
        });
        DEFAULT_MODEL = new SpecificData(){
            private final Conversion<?> fixedDecimalConversion = new FixedDecimalConversion();
            private final Conversion<?> intDecimalConversion = new IntDecimalConversion();
            private final Conversion<?> longDecimalConversion = new LongDecimalConversion();
            private final Conversion<?> uuidConversion = new UUIDConversion();
            {
                this.addLogicalTypeConversion(this.fixedDecimalConversion);
                this.addLogicalTypeConversion(this.uuidConversion);
            }

            @Override
            public <T> Conversion<T> getConversionByClass(Class<T> datumClass, LogicalType logicalType) {
                if (logicalType == null) {
                    return null;
                }
                if (logicalType instanceof ParquetDecimal) {
                    ParquetDecimal decimal = (ParquetDecimal)logicalType;
                    if (decimal.precision() <= 9) {
                        return this.intDecimalConversion;
                    }
                    if (decimal.precision() <= 18) {
                        return this.longDecimalConversion;
                    }
                    return this.fixedDecimalConversion;
                }
                if ("uuid".equals(logicalType.getName())) {
                    return this.uuidConversion;
                }
                return super.getConversionByClass(datumClass, logicalType);
            }

            public Conversion<Object> getConversionFor(LogicalType logicalType) {
                if (logicalType == null) {
                    return null;
                }
                if (logicalType instanceof LogicalTypes.Decimal) {
                    LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                    if (decimal.getPrecision() <= 9) {
                        return this.intDecimalConversion;
                    }
                    if (decimal.getPrecision() <= 18) {
                        return this.longDecimalConversion;
                    }
                    return this.fixedDecimalConversion;
                }
                if ("uuid".equals(logicalType.getName())) {
                    return this.uuidConversion;
                }
                return super.getConversionFor(logicalType);
            }
        };
    }

    private static class Pair<K, V> {
        private final K first;
        private final V second;

        Pair(K first, V second) {
            this.first = first;
            this.second = second;
        }

        public K getFirst() {
            return this.first;
        }

        public V getSecond() {
            return this.second;
        }
    }

    private static class ParquetDecimalSchemaConverter
    extends AvroSchemaVisitor<Schema> {
        private ParquetDecimalSchemaConverter() {
        }

        @Override
        public Schema record(Schema record, List<String> names, List<Schema> types) {
            List<Schema.Field> fields = record.getFields();
            int length = fields.size();
            boolean hasChange = false;
            if (length != types.size()) {
                hasChange = true;
            }
            ArrayList<Schema.Field> newFields = Lists.newArrayListWithExpectedSize(length);
            for (int i = 0; i < length; ++i) {
                Schema.Field field = fields.get(i);
                Schema type = types.get(i);
                newFields.add(ParquetDecimalSchemaConverter.copyField(field, type));
                if (Objects.equal(field.schema(), type)) continue;
                hasChange = true;
            }
            if (hasChange) {
                return ParquetDecimalSchemaConverter.copyRecord(record, newFields);
            }
            return record;
        }

        @Override
        public Schema union(Schema union, List<Schema> options) {
            if (!this.isIdentical(union.getTypes(), options)) {
                return Schema.createUnion(options);
            }
            return union;
        }

        @Override
        public Schema array(Schema array, Schema element) {
            if (!Objects.equal(array.getElementType(), element)) {
                return Schema.createArray(element);
            }
            return array;
        }

        @Override
        public Schema map(Schema map, Schema value) {
            if (!Objects.equal(map.getValueType(), value)) {
                return Schema.createMap(value);
            }
            return map;
        }

        @Override
        public Schema primitive(Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType instanceof LogicalTypes.Decimal) {
                LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                if (decimal.getPrecision() <= 9) {
                    return new ParquetDecimal(decimal.getPrecision(), decimal.getScale()).addToSchema(Schema.create(Schema.Type.INT));
                }
                if (decimal.getPrecision() <= 18) {
                    return new ParquetDecimal(decimal.getPrecision(), decimal.getScale()).addToSchema(Schema.create(Schema.Type.LONG));
                }
                return new ParquetDecimal(decimal.getPrecision(), decimal.getScale()).addToSchema(Schema.createFixed(primitive.getName(), null, null, TypeUtil.decimalRequiredBytes(decimal.getPrecision())));
            }
            return primitive;
        }

        private boolean isIdentical(List<Schema> types, List<Schema> replacements) {
            if (types.size() != replacements.size()) {
                return false;
            }
            int length = types.size();
            for (int i = 0; i < length; ++i) {
                if (Objects.equal(types.get(i), replacements.get(i))) continue;
                return false;
            }
            return true;
        }

        private static Schema copyRecord(Schema record, List<Schema.Field> newFields) {
            Schema copy = Schema.createRecord(record.getName(), record.getDoc(), record.getNamespace(), record.isError(), newFields);
            for (Map.Entry<String, Object> prop : record.getObjectProps().entrySet()) {
                copy.addProp(prop.getKey(), prop.getValue());
            }
            return copy;
        }

        private static Schema.Field copyField(Schema.Field field, Schema newSchema) {
            Schema.Field copy = new Schema.Field(field.name(), newSchema, field.doc(), field.defaultVal(), field.order());
            for (Map.Entry<String, Object> prop : field.getObjectProps().entrySet()) {
                copy.addProp(prop.getKey(), prop.getValue());
            }
            return copy;
        }
    }

    private static class FixedDecimalConversion
    extends Conversions.DecimalConversion {
        private final WeakHashMap<Pair<Integer, Integer>, LogicalType> decimalsByScale = new WeakHashMap();

        private FixedDecimalConversion() {
        }

        @Override
        public String getLogicalTypeName() {
            return "parquet-decimal";
        }

        @Override
        public BigDecimal fromFixed(GenericFixed value, Schema schema, LogicalType type) {
            ParquetDecimal dec = (ParquetDecimal)type;
            return new BigDecimal(new BigInteger(value.bytes()), dec.scale());
        }

        @Override
        public GenericFixed toFixed(BigDecimal value, Schema schema, LogicalType type) {
            ParquetDecimal dec = (ParquetDecimal)type;
            Pair<Integer, Integer> key = new Pair<Integer, Integer>(dec.precision(), dec.scale());
            return super.toFixed(value, schema, this.decimalsByScale.computeIfAbsent(key, k -> LogicalTypes.decimal((Integer)k.getFirst(), (Integer)k.getSecond())));
        }
    }

    private static class LongDecimalConversion
    extends Conversion<BigDecimal> {
        private LongDecimalConversion() {
        }

        @Override
        public Class<BigDecimal> getConvertedType() {
            return BigDecimal.class;
        }

        @Override
        public String getLogicalTypeName() {
            return "parquet-decimal";
        }

        @Override
        public BigDecimal fromLong(Long value, Schema schema, LogicalType type) {
            return BigDecimal.valueOf(value, ((ParquetDecimal)type).scale());
        }

        @Override
        public Long toLong(BigDecimal value, Schema schema, LogicalType type) {
            return value.unscaledValue().longValue();
        }
    }

    private static class IntDecimalConversion
    extends Conversion<BigDecimal> {
        private IntDecimalConversion() {
        }

        @Override
        public Class<BigDecimal> getConvertedType() {
            return BigDecimal.class;
        }

        @Override
        public String getLogicalTypeName() {
            return "parquet-decimal";
        }

        @Override
        public BigDecimal fromInt(Integer value, Schema schema, LogicalType type) {
            return BigDecimal.valueOf(value.intValue(), ((ParquetDecimal)type).scale());
        }

        @Override
        public Integer toInt(BigDecimal value, Schema schema, LogicalType type) {
            return value.unscaledValue().intValue();
        }
    }

    static class ParquetDecimal
    extends LogicalType {
        private static final String NAME = "parquet-decimal";
        private final int precision;
        private final int scale;

        ParquetDecimal(int precision, int scale) {
            super(NAME);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public String getName() {
            return NAME;
        }

        int precision() {
            return this.precision;
        }

        int scale() {
            return this.scale;
        }

        @Override
        public Schema addToSchema(Schema schema) {
            super.addToSchema(schema);
            schema.addProp("precision", String.valueOf(this.precision));
            schema.addProp("scale", String.valueOf(this.scale));
            return schema;
        }

        @Override
        public void validate(Schema schema) {
            super.validate(schema);
            switch (schema.getType()) {
                case INT: {
                    Preconditions.checkArgument(this.precision <= 9, "Int cannot hold decimal precision: %s", this.precision);
                    break;
                }
                case LONG: {
                    Preconditions.checkArgument(this.precision <= 18, "Long cannot hold decimal precision: %s", this.precision);
                    break;
                }
                case FIXED: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid base type for decimal: " + schema);
                }
            }
            Preconditions.checkArgument(this.scale >= 0, "Scale %s cannot be negative", this.scale);
            Preconditions.checkArgument(this.scale <= this.precision, "Scale %s cannot be less than precision %s", this.scale, this.precision);
        }
    }
}

