/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedSupport;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.hive.HiveVersion;
import org.apache.iceberg.mr.InputFormatConfig;
import org.apache.iceberg.mr.hive.HiveIcebergFilterFactory;
import org.apache.iceberg.mr.hive.HiveIcebergSplit;
import org.apache.iceberg.mr.mapred.AbstractMapredIcebergRecordReader;
import org.apache.iceberg.mr.mapred.Container;
import org.apache.iceberg.mr.mapred.MapredIcebergInputFormat;
import org.apache.iceberg.mr.mapreduce.IcebergInputFormat;
import org.apache.iceberg.mr.mapreduce.IcebergSplit;
import org.apache.iceberg.mr.mapreduce.IcebergSplitContainer;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.SerializationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIcebergInputFormat
extends MapredIcebergInputFormat<Record>
implements CombineHiveInputFormat.AvoidSplitCombination,
VectorizedInputFormatInterface {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergInputFormat.class);
    private static final String HIVE_VECTORIZED_RECORDREADER_CLASS = "org.apache.iceberg.mr.hive.vector.HiveIcebergVectorizedRecordReader";
    private static final DynConstructors.Ctor<AbstractMapredIcebergRecordReader> HIVE_VECTORIZED_RECORDREADER_CTOR = HiveVersion.min(HiveVersion.HIVE_3) ? DynConstructors.builder(AbstractMapredIcebergRecordReader.class).impl("org.apache.iceberg.mr.hive.vector.HiveIcebergVectorizedRecordReader", IcebergInputFormat.class, IcebergSplit.class, JobConf.class, Reporter.class).build() : null;

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        String hiveFilter = job.get("hive.io.filter.expr.serialized");
        if (hiveFilter != null) {
            ExprNodeGenericFuncDesc exprNodeDesc = (ExprNodeGenericFuncDesc)SerializationUtilities.deserializeObject((String)hiveFilter, ExprNodeGenericFuncDesc.class);
            SearchArgument sarg = ConvertAstToSearchArg.create((Configuration)job, (ExprNodeGenericFuncDesc)exprNodeDesc);
            try {
                Expression filter = HiveIcebergFilterFactory.generateFilterExpression(sarg);
                job.set("iceberg.mr.filter.expression", SerializationUtil.serializeToBase64(filter));
            }
            catch (UnsupportedOperationException e) {
                LOG.warn("Unable to create Iceberg filter, continuing without filter (will be applied by Hive later): ", (Throwable)e);
            }
        }
        String[] selectedColumns = ColumnProjectionUtils.getReadColumnNames((Configuration)job);
        job.setStrings("iceberg.mr.selected.columns", selectedColumns);
        String location = job.get("iceberg.mr.table.location");
        return (InputSplit[])Arrays.stream(super.getSplits(job, numSplits)).map(split -> new HiveIcebergSplit((IcebergSplit)split, location)).toArray(InputSplit[]::new);
    }

    @Override
    public RecordReader<Void, Container<Record>> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        String[] selectedColumns = ColumnProjectionUtils.getReadColumnNames((Configuration)job);
        job.setStrings("iceberg.mr.selected.columns", selectedColumns);
        if (HiveConf.getBoolVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED) && Utilities.getVectorizedRowBatchCtx((Configuration)job) != null) {
            Preconditions.checkArgument(HiveVersion.min(HiveVersion.HIVE_3), "Vectorization only supported for Hive 3+");
            job.setEnum("iceberg.mr.in.memory.data.model", (Enum)InputFormatConfig.InMemoryDataModel.HIVE);
            job.setBoolean("skip.residual.filtering", true);
            IcebergSplit icebergSplit = ((IcebergSplitContainer)split).icebergSplit();
            return HIVE_VECTORIZED_RECORDREADER_CTOR.newInstance(new Object[]{new IcebergInputFormat(), icebergSplit, job, reporter});
        }
        return super.getRecordReader(split, job, reporter);
    }

    public boolean shouldSkipCombine(Path path, Configuration conf) {
        return true;
    }

    public VectorizedSupport.Support[] getSupportedFeatures() {
        return new VectorizedSupport.Support[0];
    }
}

