/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.avro.LogicalType;
import org.apache.iceberg.shaded.org.apache.avro.Schema;

public class ApplyNameMapping
extends AvroSchemaVisitor<Schema> {
    private final NameMapping nameMapping;

    public ApplyNameMapping(NameMapping nameMapping) {
        this.nameMapping = nameMapping;
    }

    @Override
    public Schema record(Schema record, List<String> names, List<Schema> fields) {
        List<Schema.Field> originalFields = record.getFields();
        ArrayList<Schema.Field> newFields = Lists.newArrayList();
        boolean hasChange = false;
        for (int i = 0; i < originalFields.size(); ++i) {
            Schema newSchema = fields.get(i);
            Schema.Field field = originalFields.get(i);
            Integer fieldId = AvroSchemaUtil.getFieldId(field, this.nameMapping, this.fieldNames());
            if (newSchema != null && fieldId != null) {
                newFields.add(ApplyNameMapping.copyField(field, newSchema, fieldId));
                hasChange = true;
                continue;
            }
            newFields.add(ApplyNameMapping.copyField(field, field.schema(), null));
        }
        if (!hasChange) {
            return record;
        }
        return this.copyRecord(record, newFields);
    }

    @Override
    public Schema union(Schema union, List<Schema> options) {
        if (options.equals(union.getTypes())) {
            return union;
        }
        List<Schema> validOptions = options.stream().filter(Objects::nonNull).collect(Collectors.toList());
        return this.copyProps(union, Schema.createUnion(validOptions));
    }

    @Override
    public Schema array(Schema array, Schema element) {
        if (array.getLogicalType() instanceof LogicalMap || this.isKeyValueMapping(this.fieldNames()) && AvroSchemaUtil.isKeyValueSchema(array.getElementType())) {
            return this.copyProps(array, Schema.createArray(element));
        }
        Integer elementId = AvroSchemaUtil.elementId(array);
        if (elementId != null) {
            if (array.getElementType().equals(element)) {
                return array;
            }
            return this.copyProps(array, this.createArray(element, elementId));
        }
        MappedField mapping = this.nameMapping.find(this.fieldNames(), "element");
        if (mapping != null) {
            return this.copyProps(array, this.createArray(element, mapping.id()));
        }
        return array;
    }

    private boolean isKeyValueMapping(Iterable<String> names) {
        return this.nameMapping.find(names, "key") != null && this.nameMapping.find(names, "value") != null;
    }

    @Override
    public Schema map(Schema map, Schema value) {
        Integer keyId = AvroSchemaUtil.keyId(map);
        Integer valueId = AvroSchemaUtil.valueId(map);
        if (keyId != null && valueId != null) {
            if (map.getValueType().equals(value)) {
                return map;
            }
            return this.copyProps(map, this.createMap(value, keyId, valueId));
        }
        MappedField keyMapping = this.nameMapping.find(this.fieldNames(), "key");
        MappedField valueMapping = this.nameMapping.find(this.fieldNames(), "value");
        if (keyMapping != null && valueMapping != null) {
            return this.copyProps(map, this.createMap(value, keyMapping.id(), valueMapping.id()));
        }
        return map;
    }

    @Override
    public Schema primitive(Schema primitive) {
        return primitive;
    }

    private Schema copyRecord(Schema record, List<Schema.Field> newFields) {
        Schema copy = Schema.createRecord(record.getName(), record.getDoc(), record.getNamespace(), record.isError(), newFields);
        this.copyProps(record, copy);
        return copy;
    }

    static Schema.Field copyField(Schema.Field field, Schema newSchema, Integer fieldId) {
        Schema.Field copy = new Schema.Field(field.name(), newSchema, field.doc(), field.defaultVal(), field.order());
        for (Map.Entry<String, Object> prop : field.getObjectProps().entrySet()) {
            copy.addProp(prop.getKey(), prop.getValue());
        }
        if (fieldId != null) {
            copy.addProp("field-id", fieldId);
        }
        for (String alias : field.aliases()) {
            copy.addAlias(alias);
        }
        return copy;
    }

    private Schema createMap(Schema value, int keyId, int valueId) {
        Schema result = Schema.createMap(value);
        result.addProp("key-id", keyId);
        result.addProp("value-id", valueId);
        return result;
    }

    private Schema createArray(Schema element, int elementId) {
        Schema result = Schema.createArray(element);
        result.addProp("element-id", elementId);
        return result;
    }

    private Schema copyProps(Schema from, Schema copy) {
        for (Map.Entry<String, Object> prop : from.getObjectProps().entrySet()) {
            copy.addProp(prop.getKey(), prop.getValue());
        }
        LogicalType logicalType = from.getLogicalType();
        if (logicalType != null) {
            logicalType.addToSchema(copy);
        }
        return copy;
    }
}

