/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Locale;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Comparators;

public enum FileFormat {
    ORC("orc", true),
    PARQUET("parquet", true),
    AVRO("avro", true),
    METADATA("metadata.json", false);

    private final String ext;
    private final boolean splittable;
    private static final FileFormat[] VALUES;

    private FileFormat(String ext, boolean splittable) {
        this.ext = "." + ext;
        this.splittable = splittable;
    }

    public boolean isSplittable() {
        return this.splittable;
    }

    public String addExtension(String filename) {
        if (filename.endsWith(this.ext)) {
            return filename;
        }
        return filename + this.ext;
    }

    public static FileFormat fromFileName(CharSequence filename) {
        for (FileFormat format : VALUES) {
            int extStart = filename.length() - format.ext.length();
            if (Comparators.charSequences().compare(format.ext, filename.subSequence(extStart, filename.length())) != 0) continue;
            return format;
        }
        return null;
    }

    public static FileFormat fromString(String fileFormat) {
        Preconditions.checkArgument(null != fileFormat, "Invalid file format: null");
        try {
            return FileFormat.valueOf(fileFormat.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid file format: %s", fileFormat), e);
        }
    }

    static {
        VALUES = FileFormat.values();
    }
}

