/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3.signer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.iceberg.CatalogProperties;
import org.apache.iceberg.aws.s3.signer.ImmutableKey;
import org.apache.iceberg.aws.s3.signer.ImmutableS3SignRequest;
import org.apache.iceberg.aws.s3.signer.ImmutableS3V4RestSignerClient;
import org.apache.iceberg.aws.s3.signer.ImmutableSignedComponent;
import org.apache.iceberg.aws.s3.signer.S3ObjectMapper;
import org.apache.iceberg.aws.s3.signer.S3SignRequest;
import org.apache.iceberg.aws.s3.signer.S3SignResponse;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.ErrorHandlers;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.ResourcePaths;
import org.apache.iceberg.rest.auth.AuthConfig;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Cache;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.ThreadPools;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.signer.internal.AbstractAws4Signer;
import software.amazon.awssdk.auth.signer.internal.Aws4SignerRequestParams;
import software.amazon.awssdk.auth.signer.params.Aws4PresignerParams;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.auth.signer.params.AwsS3V4SignerParams;
import software.amazon.awssdk.core.checksums.SdkChecksum;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.utils.IoUtils;

@Value.Immutable
public abstract class S3V4RestSignerClient
extends AbstractAws4Signer<AwsS3V4SignerParams, Aws4PresignerParams> {
    private static final Logger LOG = LoggerFactory.getLogger(S3V4RestSignerClient.class);
    public static final String S3_SIGNER_URI = "s3.signer.uri";
    public static final String S3_SIGNER_ENDPOINT = "s3.signer.endpoint";
    static final String S3_SIGNER_DEFAULT_ENDPOINT = "v1/aws/s3/sign";
    static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    static final String CACHE_CONTROL = "Cache-Control";
    static final String CACHE_CONTROL_PRIVATE = "private";
    static final String CACHE_CONTROL_NO_CACHE = "no-cache";
    private static final Cache<Key, SignedComponent> SIGNED_COMPONENT_CACHE = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).maximumSize(100L).build();
    private static final String SCOPE = "sign";
    private static volatile ScheduledExecutorService tokenRefreshExecutor;
    private static volatile RESTClient httpClient;
    private static volatile Cache<String, OAuth2Util.AuthSession> authSessionCache;

    public abstract Map<String, String> properties();

    @Value.Default
    public Supplier<Map<String, String>> requestPropertiesSupplier() {
        return Collections::emptyMap;
    }

    @Value.Lazy
    public String baseSignerUri() {
        return this.properties().getOrDefault(S3_SIGNER_URI, this.properties().get("uri"));
    }

    @Value.Lazy
    public String endpoint() {
        return this.properties().getOrDefault(S3_SIGNER_ENDPOINT, S3_SIGNER_DEFAULT_ENDPOINT);
    }

    @Nullable
    @Value.Lazy
    public String credential() {
        return this.properties().get("credential");
    }

    @Value.Lazy
    public String oauth2ServerUri() {
        return this.properties().getOrDefault("oauth2-server-uri", ResourcePaths.tokens());
    }

    @Value.Lazy
    public Map<String, String> optionalOAuthParams() {
        return OAuth2Util.buildOptionalParam(this.properties());
    }

    @Value.Default
    public Supplier<String> token() {
        return () -> this.properties().get("token");
    }

    @Value.Lazy
    boolean keepTokenRefreshed() {
        return PropertyUtil.propertyAsBoolean(this.properties(), "token-refresh-enabled", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    ScheduledExecutorService tokenRefreshExecutor() {
        if (!this.keepTokenRefreshed()) {
            return null;
        }
        if (null != tokenRefreshExecutor) return tokenRefreshExecutor;
        Class<S3V4RestSignerClient> clazz = S3V4RestSignerClient.class;
        synchronized (S3V4RestSignerClient.class) {
            if (null != tokenRefreshExecutor) return tokenRefreshExecutor;
            tokenRefreshExecutor = ThreadPools.newScheduledPool("s3-signer-token-refresh", 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tokenRefreshExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cache<String, OAuth2Util.AuthSession> authSessionCache() {
        if (null != authSessionCache) return authSessionCache;
        Class<S3V4RestSignerClient> clazz = S3V4RestSignerClient.class;
        synchronized (S3V4RestSignerClient.class) {
            if (null != authSessionCache) return authSessionCache;
            long expirationIntervalMs = PropertyUtil.propertyAsLong(this.properties(), "auth.session-timeout-ms", CatalogProperties.AUTH_SESSION_TIMEOUT_MS_DEFAULT);
            authSessionCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMillis(expirationIntervalMs)).removalListener((id, auth, cause) -> {
                if (null != auth) {
                    LOG.trace("Stopping refresh for AuthSession");
                    auth.stopRefreshing();
                }
            }).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return authSessionCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RESTClient httpClient() {
        if (null != httpClient) return httpClient;
        Class<S3V4RestSignerClient> clazz = S3V4RestSignerClient.class;
        synchronized (S3V4RestSignerClient.class) {
            if (null != httpClient) return httpClient;
            httpClient = HTTPClient.builder(this.properties()).uri(this.baseSignerUri()).withObjectMapper(S3ObjectMapper.mapper()).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return httpClient;
        }
    }

    private OAuth2Util.AuthSession authSession() {
        String token = this.token().get();
        if (null != token) {
            return this.authSessionCache().get(token, id -> OAuth2Util.AuthSession.fromAccessToken(this.httpClient(), this.tokenRefreshExecutor(), token, this.expiresAtMillis(this.properties()), new OAuth2Util.AuthSession(ImmutableMap.of(), AuthConfig.builder().token(token).credential(this.credential()).scope(SCOPE).oauth2ServerUri(this.oauth2ServerUri()).optionalOAuthParams(this.optionalOAuthParams()).build())));
        }
        if (this.credentialProvided()) {
            return this.authSessionCache().get(this.credential(), id -> {
                OAuth2Util.AuthSession session = new OAuth2Util.AuthSession(ImmutableMap.of(), AuthConfig.builder().credential(this.credential()).scope(SCOPE).oauth2ServerUri(this.oauth2ServerUri()).optionalOAuthParams(this.optionalOAuthParams()).build());
                long startTimeMillis = System.currentTimeMillis();
                OAuthTokenResponse authResponse = OAuth2Util.fetchToken(this.httpClient(), session.headers(), this.credential(), SCOPE, this.oauth2ServerUri(), this.optionalOAuthParams());
                return OAuth2Util.AuthSession.fromTokenResponse(this.httpClient(), this.tokenRefreshExecutor(), authResponse, startTimeMillis, session);
            });
        }
        return OAuth2Util.AuthSession.empty();
    }

    private boolean credentialProvided() {
        return null != this.credential() && !this.credential().isEmpty();
    }

    private Long expiresAtMillis(Map<String, String> properties) {
        if (properties.containsKey("token-expires-in-ms")) {
            long expiresInMillis = PropertyUtil.propertyAsLong(properties, "token-expires-in-ms", 3600000L);
            return System.currentTimeMillis() + expiresInMillis;
        }
        return null;
    }

    @Value.Check
    protected void check() {
        Preconditions.checkArgument(this.properties().containsKey(S3_SIGNER_URI) || this.properties().containsKey("uri"), "S3 signer service URI is required");
    }

    protected void processRequestPayload(SdkHttpFullRequest.Builder mutableRequest, byte[] signature, byte[] signingKey, Aws4SignerRequestParams signerRequestParams, AwsS3V4SignerParams signerParams) {
        this.checkSignerParams(signerParams);
    }

    protected void processRequestPayload(SdkHttpFullRequest.Builder mutableRequest, byte[] signature, byte[] signingKey, Aws4SignerRequestParams signerRequestParams, AwsS3V4SignerParams signerParams, SdkChecksum sdkChecksum) {
        this.checkSignerParams(signerParams);
    }

    protected String calculateContentHashPresign(SdkHttpFullRequest.Builder mutableRequest, Aws4PresignerParams signerParams) {
        return UNSIGNED_PAYLOAD;
    }

    public SdkHttpFullRequest presign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        throw new UnsupportedOperationException("Pre-signing not allowed.");
    }

    public SdkHttpFullRequest sign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        SignedComponent signedComponent;
        AwsS3V4SignerParams signerParams = ((AwsS3V4SignerParams.Builder)this.extractSignerParams((Aws4SignerParams.Builder)AwsS3V4SignerParams.builder(), executionAttributes)).build();
        ImmutableS3SignRequest remoteSigningRequest = ImmutableS3SignRequest.builder().method(request.method().name()).region(signerParams.signingRegion().id()).uri(request.getUri()).headers(request.headers()).properties(this.requestPropertiesSupplier().get()).body(this.bodyAsString(request)).build();
        Key cacheKey = Key.from(remoteSigningRequest);
        SignedComponent cachedSignedComponent = SIGNED_COMPONENT_CACHE.getIfPresent(cacheKey);
        if (null != cachedSignedComponent) {
            signedComponent = cachedSignedComponent;
        } else {
            HashMap<String, String> responseHeaders = Maps.newHashMap();
            Consumer<Map<String, String>> responseHeadersConsumer = responseHeaders::putAll;
            S3SignResponse s3SignResponse = this.httpClient().post(this.endpoint(), (RESTRequest)remoteSigningRequest, S3SignResponse.class, () -> this.authSession().headers(), ErrorHandlers.defaultErrorHandler(), responseHeadersConsumer);
            signedComponent = ImmutableSignedComponent.builder().headers(s3SignResponse.headers()).signedURI(s3SignResponse.uri()).build();
            if (this.canBeCached(responseHeaders)) {
                SIGNED_COMPONENT_CACHE.put(cacheKey, signedComponent);
            }
        }
        SdkHttpFullRequest.Builder mutableRequest = request.toBuilder();
        mutableRequest.encodedPath("");
        mutableRequest.uri(signedComponent.signedURI());
        this.reconstructHeaders(signedComponent.headers(), mutableRequest);
        return mutableRequest.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String bodyAsString(SdkHttpFullRequest request) {
        if (!this.isDeleteObjectsRequest(request)) return null;
        if (!request.contentStreamProvider().isPresent()) return null;
        try (InputStream is = ((ContentStreamProvider)request.contentStreamProvider().get()).newStream();){
            String string = IoUtils.toUtf8String((InputStream)is);
            return string;
        }
        catch (IOException e) {
            LOG.debug("Failed to determine body for S3 sign request", (Throwable)e);
        }
        return null;
    }

    private boolean isDeleteObjectsRequest(SdkHttpFullRequest request) {
        return request.method() == SdkHttpMethod.POST && request.rawQueryParameters().containsKey("delete");
    }

    private void reconstructHeaders(Map<String, List<String>> signedAndUnsignedHeaders, SdkHttpFullRequest.Builder mutableRequest) {
        HashMap<String, List<String>> headers = Maps.newHashMap(signedAndUnsignedHeaders);
        headers.remove(CACHE_CONTROL);
        headers.putAll(mutableRequest.headers());
        headers.forEach((arg_0, arg_1) -> ((SdkHttpFullRequest.Builder)mutableRequest).putHeader(arg_0, arg_1));
    }

    private boolean canBeCached(Map<String, String> responseHeaders) {
        return CACHE_CONTROL_PRIVATE.equals(responseHeaders.get(CACHE_CONTROL));
    }

    private void checkSignerParams(AwsS3V4SignerParams signerParams) {
        if (signerParams.enablePayloadSigning().booleanValue()) {
            throw new UnsupportedOperationException("Payload signing not supported");
        }
        if (signerParams.enableChunkedEncoding().booleanValue()) {
            throw new UnsupportedOperationException("Chunked encoding not supported");
        }
    }

    public static S3V4RestSignerClient create(Map<String, String> properties) {
        return ImmutableS3V4RestSignerClient.builder().properties(properties).build();
    }

    @Value.Immutable
    static interface SignedComponent {
        public Map<String, List<String>> headers();

        public URI signedURI();
    }

    @Value.Immutable
    static interface Key {
        public String method();

        public String region();

        public String uri();

        public static Key from(S3SignRequest request) {
            return ImmutableKey.builder().method(request.method()).region(request.region()).uri(request.uri().toString()).build();
        }
    }
}

