/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.BaseCommitService;
import org.apache.iceberg.actions.RewriteFileGroup;
import org.apache.iceberg.exceptions.CleanableFailure;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteDataFilesCommitManager {
    private static final Logger LOG = LoggerFactory.getLogger(RewriteDataFilesCommitManager.class);
    private final Table table;
    private final long startingSnapshotId;
    private final boolean useStartingSequenceNumber;
    private final Map<String, String> snapshotProperties;

    public RewriteDataFilesCommitManager(Table table) {
        this(table, table.currentSnapshot().snapshotId());
    }

    public RewriteDataFilesCommitManager(Table table, long startingSnapshotId) {
        this(table, startingSnapshotId, true);
    }

    public RewriteDataFilesCommitManager(Table table, long startingSnapshotId, boolean useStartingSequenceNumber) {
        this(table, startingSnapshotId, useStartingSequenceNumber, ImmutableMap.of());
    }

    public RewriteDataFilesCommitManager(Table table, long startingSnapshotId, boolean useStartingSequenceNumber, Map<String, String> snapshotProperties) {
        this.table = table;
        this.startingSnapshotId = startingSnapshotId;
        this.useStartingSequenceNumber = useStartingSequenceNumber;
        this.snapshotProperties = snapshotProperties;
    }

    public void commitFileGroups(Set<RewriteFileGroup> fileGroups) {
        HashSet<DataFile> rewrittenDataFiles = Sets.newHashSet();
        HashSet<DataFile> addedDataFiles = Sets.newHashSet();
        for (RewriteFileGroup group : fileGroups) {
            rewrittenDataFiles.addAll(group.rewrittenFiles());
            addedDataFiles.addAll(group.addedFiles());
        }
        RewriteFiles rewrite = this.table.newRewrite().validateFromSnapshot(this.startingSnapshotId);
        if (this.useStartingSequenceNumber) {
            long sequenceNumber = this.table.snapshot(this.startingSnapshotId).sequenceNumber();
            rewrite.rewriteFiles(rewrittenDataFiles, addedDataFiles, sequenceNumber);
        } else {
            rewrite.rewriteFiles(rewrittenDataFiles, addedDataFiles);
        }
        this.snapshotProperties.forEach(rewrite::set);
        rewrite.commit();
    }

    public void abortFileGroup(RewriteFileGroup fileGroup) {
        Preconditions.checkState(fileGroup.addedFiles() != null, "Cannot abort a fileGroup that was not rewritten");
        Tasks.foreach(fileGroup.addedFiles()).noRetry().suppressFailureWhenFinished().onFailure((dataFile, exc) -> LOG.warn("Failed to delete: {}", (Object)dataFile.path(), (Object)exc)).run(dataFile -> this.table.io().deleteFile(dataFile.path().toString()));
    }

    public void commitOrClean(Set<RewriteFileGroup> rewriteGroups) {
        try {
            this.commitFileGroups(rewriteGroups);
        }
        catch (CommitStateUnknownException e) {
            LOG.error("Commit state unknown for {}, cannot clean up files because they may have been committed successfully.", rewriteGroups, (Object)e);
            throw e;
        }
        catch (Exception e) {
            if (e instanceof CleanableFailure) {
                LOG.error("Cannot commit groups {}, attempting to clean up written files", rewriteGroups, (Object)e);
                rewriteGroups.forEach(this::abortFileGroup);
            }
            throw e;
        }
    }

    public CommitService service(int rewritesPerCommit) {
        return new CommitService(rewritesPerCommit);
    }

    public class CommitService
    extends BaseCommitService<RewriteFileGroup> {
        CommitService(int rewritesPerCommit) {
            super(RewriteDataFilesCommitManager.this.table, rewritesPerCommit);
        }

        @Override
        protected void commitOrClean(Set<RewriteFileGroup> batch) {
            RewriteDataFilesCommitManager.this.commitOrClean(batch);
        }

        @Override
        protected void abortFileGroup(RewriteFileGroup group) {
            RewriteDataFilesCommitManager.this.abortFileGroup(group);
        }
    }
}

