/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.DataTaskParser;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.FileScanTaskParser;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.util.JsonUtil;

public class ScanTaskParser {
    private static final String TASK_TYPE = "task-type";

    private ScanTaskParser() {
    }

    public static String toJson(FileScanTask fileScanTask) {
        Preconditions.checkArgument(fileScanTask != null, "Invalid scan task: null");
        return JsonUtil.generate(generator -> ScanTaskParser.toJson(fileScanTask, generator), false);
    }

    public static FileScanTask fromJson(String json, boolean caseSensitive) {
        Preconditions.checkArgument(json != null, "Invalid JSON string for scan task: null");
        return JsonUtil.parse(json, node -> ScanTaskParser.fromJson(node, caseSensitive));
    }

    private static void toJson(FileScanTask fileScanTask, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        if (fileScanTask instanceof StaticDataTask) {
            generator.writeStringField(TASK_TYPE, TaskType.DATA_TASK.typeName());
            DataTaskParser.toJson((StaticDataTask)fileScanTask, generator);
        } else if (fileScanTask instanceof BaseFileScanTask || fileScanTask instanceof BaseFileScanTask.SplitScanTask) {
            generator.writeStringField(TASK_TYPE, TaskType.FILE_SCAN_TASK.typeName());
            FileScanTaskParser.toJson(fileScanTask, generator);
        } else {
            throw new UnsupportedOperationException("Unsupported task type: " + fileScanTask.getClass().getCanonicalName());
        }
        generator.writeEndObject();
    }

    private static FileScanTask fromJson(JsonNode jsonNode, boolean caseSensitive) {
        TaskType taskType = TaskType.FILE_SCAN_TASK;
        String taskTypeStr = JsonUtil.getStringOrNull(TASK_TYPE, jsonNode);
        if (null != taskTypeStr) {
            taskType = TaskType.fromTypeName(taskTypeStr);
        }
        switch (taskType) {
            case FILE_SCAN_TASK: {
                return FileScanTaskParser.fromJson(jsonNode, caseSensitive);
            }
            case DATA_TASK: {
                return DataTaskParser.fromJson(jsonNode);
            }
        }
        throw new UnsupportedOperationException("Unsupported task type: " + taskType.typeName());
    }

    private static enum TaskType {
        FILE_SCAN_TASK("file-scan-task"),
        DATA_TASK("data-task");

        private final String value;

        private TaskType(String value) {
            this.value = value;
        }

        public static TaskType fromTypeName(String value) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(value), "Invalid task type name: null or empty");
            if (FILE_SCAN_TASK.typeName().equalsIgnoreCase(value)) {
                return FILE_SCAN_TASK;
            }
            if (DATA_TASK.typeName().equalsIgnoreCase(value)) {
                return DATA_TASK;
            }
            throw new IllegalArgumentException("Unknown task type: " + value);
        }

        public String typeName() {
            return this.value;
        }
    }
}

