/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.RefreshToken;
import org.projectnessie.client.auth.oauth2.Token;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RefreshToken", generator="Immutables")
@Immutable
public final class ImmutableRefreshToken
implements RefreshToken {
    private final String payload;
    @Nullable
    private final Instant expirationTime;

    private ImmutableRefreshToken(String payload, @Nullable Instant expirationTime) {
        this.payload = payload;
        this.expirationTime = expirationTime;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    @Nullable
    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    public final ImmutableRefreshToken withPayload(String value) {
        String newValue = Objects.requireNonNull(value, "payload");
        if (this.payload.equals(newValue)) {
            return this;
        }
        return new ImmutableRefreshToken(newValue, this.expirationTime);
    }

    public final ImmutableRefreshToken withExpirationTime(@Nullable Instant value) {
        if (this.expirationTime == value) {
            return this;
        }
        return new ImmutableRefreshToken(this.payload, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRefreshToken && this.equalTo(0, (ImmutableRefreshToken)another);
    }

    private boolean equalTo(int synthetic, ImmutableRefreshToken another) {
        return this.payload.equals(another.payload) && Objects.equals(this.expirationTime, another.expirationTime);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.payload.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.expirationTime);
        return h2;
    }

    public String toString() {
        return "RefreshToken{payload=" + this.payload + ", expirationTime=" + this.expirationTime + "}";
    }

    public static ImmutableRefreshToken copyOf(RefreshToken instance) {
        if (instance instanceof ImmutableRefreshToken) {
            return (ImmutableRefreshToken)instance;
        }
        return ImmutableRefreshToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RefreshToken", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PAYLOAD = 1L;
        private long initBits = 1L;
        @Nullable
        private String payload;
        @Nullable
        private Instant expirationTime;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RefreshToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Token instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Instant expirationTimeValue;
            Token instance;
            long bits = 0L;
            if (object instanceof RefreshToken) {
                instance = (RefreshToken)object;
                if ((bits & 1L) == 0L) {
                    this.payload(instance.getPayload());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    expirationTimeValue = instance.getExpirationTime();
                    if (expirationTimeValue != null) {
                        this.expirationTime(expirationTimeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof Token) {
                instance = (Token)object;
                if ((bits & 1L) == 0L) {
                    this.payload(instance.getPayload());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    expirationTimeValue = instance.getExpirationTime();
                    if (expirationTimeValue != null) {
                        this.expirationTime(expirationTimeValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder payload(String payload) {
            this.payload = Objects.requireNonNull(payload, "payload");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expirationTime(@Nullable Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public ImmutableRefreshToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRefreshToken(this.payload, this.expirationTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("payload");
            }
            return "Cannot build RefreshToken, some of required attributes are not set " + attributes;
        }
    }
}

