/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.http;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonView;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.projectnessie.api.v2.ConfigApi;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.model.NessieConfiguration;
import org.projectnessie.model.RepositoryConfigResponse;
import org.projectnessie.model.UpdateRepositoryConfigRequest;
import org.projectnessie.model.UpdateRepositoryConfigResponse;
import org.projectnessie.model.ser.Views;

@Path(value="v2/config")
@Tag(name="v2")
public interface HttpConfigApi
extends ConfigApi {
    @Override
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Returns repository and server settings relevant to clients.", operationId="getConfigV2")
    @APIResponses(value={@APIResponse(responseCode="200", description="Configuration settings", content={@Content(mediaType="application/json", schema=@Schema(implementation=NessieConfiguration.class), examples={@ExampleObject(ref="nessieConfig")})}), @APIResponse(responseCode="401", description="Invalid credentials provided")})
    @JsonView(value={Views.V2.class})
    public NessieConfiguration getConfig();

    @Override
    @GET
    @Path(value="repository")
    @Produces(value={"application/json"})
    @Operation(summary="Returns repository configurations of the requested types.", operationId="getRepositoryConfig")
    @APIResponses(value={@APIResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=RepositoryConfigResponse.class, title="Repository configuration objects for the requested types.", description="The existing configuration objects for the requested types will be returned. Non-existing config objects will not be returned."))}), @APIResponse(responseCode="401", description="Invalid credentials provided")})
    @JsonView(value={Views.V2.class})
    public RepositoryConfigResponse getRepositoryConfig(@QueryParam(value="type") List<String> var1);

    @Override
    @POST
    @Path(value="repository")
    @Produces(value={"application/json"})
    @Operation(summary="Create or update a repository configuration.", operationId="updateRepositoryConfig")
    @APIResponses(value={@APIResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=UpdateRepositoryConfigResponse.class, title="The previous state of the repository configuration object.", description="When a repository configuration for the same type as in the request object did not exist, the response object will be null. Otherwise, if the configuration was updated, the old value will be returned."))}), @APIResponse(responseCode="401", description="Invalid credentials provided")})
    @JsonView(value={Views.V2.class})
    public UpdateRepositoryConfigResponse updateRepositoryConfig(UpdateRepositoryConfigRequest var1) throws NessieConflictException;
}

