/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.column.values.bitpacking;

import org.apache.iceberg.shaded.org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.iceberg.shaded.org.apache.parquet.column.values.bitpacking.BytePackerFactory;
import org.apache.iceberg.shaded.org.apache.parquet.column.values.bitpacking.BytePackerForLong;
import org.apache.iceberg.shaded.org.apache.parquet.column.values.bitpacking.BytePackerForLongFactory;
import org.apache.iceberg.shaded.org.apache.parquet.column.values.bitpacking.IntPacker;
import org.apache.iceberg.shaded.org.apache.parquet.column.values.bitpacking.IntPackerFactory;

public enum Packer {
    BIG_ENDIAN{

        @Override
        public IntPacker newIntPacker(int width) {
            return beIntPackerFactory.newIntPacker(width);
        }

        @Override
        public BytePacker newBytePacker(int width) {
            return beBytePackerFactory.newBytePacker(width);
        }

        @Override
        public BytePacker newBytePackerVector(int width) {
            throw new RuntimeException("Not currently supported!");
        }

        @Override
        public BytePackerForLong newBytePackerForLong(int width) {
            return beBytePackerForLongFactory.newBytePackerForLong(width);
        }
    }
    ,
    LITTLE_ENDIAN{

        @Override
        public IntPacker newIntPacker(int width) {
            return leIntPackerFactory.newIntPacker(width);
        }

        @Override
        public BytePacker newBytePacker(int width) {
            return leBytePackerFactory.newBytePacker(width);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public BytePacker newBytePackerVector(int width) {
            if (leBytePacker512VectorFactory == null) {
                Class<Packer> clazz = Packer.class;
                // MONITORENTER : org.apache.iceberg.shaded.org.apache.parquet.column.values.bitpacking.Packer.class
                if (leBytePacker512VectorFactory == null) {
                    leBytePacker512VectorFactory = Packer.getBytePackerFactory("ByteBitPacking512VectorLE");
                }
                // MONITOREXIT : clazz
            }
            if (leBytePacker512VectorFactory != null) return leBytePacker512VectorFactory.newBytePacker(width);
            throw new RuntimeException("No enable java vector plugin on little endian architectures");
        }

        @Override
        public BytePackerForLong newBytePackerForLong(int width) {
            return leBytePackerForLongFactory.newBytePackerForLong(width);
        }
    };

    static IntPackerFactory beIntPackerFactory;
    static IntPackerFactory leIntPackerFactory;
    static BytePackerFactory beBytePackerFactory;
    static BytePackerFactory leBytePackerFactory;
    static BytePackerFactory leBytePacker512VectorFactory;
    static BytePackerForLongFactory beBytePackerForLongFactory;
    static BytePackerForLongFactory leBytePackerForLongFactory;

    private static IntPackerFactory getIntPackerFactory(String name) {
        return (IntPackerFactory)Packer.getStaticField("org.apache.iceberg.shaded.org.apache.parquet.column.values.bitpacking." + name, "factory");
    }

    private static BytePackerFactory getBytePackerFactory(String name) {
        return (BytePackerFactory)Packer.getStaticField("org.apache.iceberg.shaded.org.apache.parquet.column.values.bitpacking." + name, "factory");
    }

    private static BytePackerForLongFactory getBytePackerForLongFactory(String name) {
        return (BytePackerForLongFactory)Packer.getStaticField("org.apache.iceberg.shaded.org.apache.parquet.column.values.bitpacking." + name, "factory");
    }

    private static Object getStaticField(String className, String fieldName) {
        try {
            return Class.forName(className).getField(fieldName).get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract IntPacker newIntPacker(int var1);

    public abstract BytePacker newBytePacker(int var1);

    public BytePacker newBytePackerVector(int width) {
        throw new RuntimeException("newBytePackerVector must be implemented by subclasses!");
    }

    public abstract BytePackerForLong newBytePackerForLong(int var1);

    static {
        beIntPackerFactory = Packer.getIntPackerFactory("LemireBitPackingBE");
        leIntPackerFactory = Packer.getIntPackerFactory("LemireBitPackingLE");
        beBytePackerFactory = Packer.getBytePackerFactory("ByteBitPackingBE");
        leBytePackerFactory = Packer.getBytePackerFactory("ByteBitPackingLE");
        leBytePacker512VectorFactory = null;
        beBytePackerForLongFactory = Packer.getBytePackerForLongFactory("ByteBitPackingForLongBE");
        leBytePackerForLongFactory = Packer.getBytePackerForLongFactory("ByteBitPackingForLongLE");
    }
}

