/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;

class UpdateableReference {
    private Reference reference;
    private final boolean mutable;

    UpdateableReference(Reference reference, boolean hashReference) {
        this.reference = reference;
        this.mutable = reference instanceof Branch && !hashReference;
    }

    public boolean refresh(NessieApiV1 api) throws NessieNotFoundException {
        if (!this.mutable) {
            return false;
        }
        Reference oldReference = this.reference;
        this.reference = api.getReference().refName(this.reference.getName()).get();
        return !oldReference.equals(this.reference);
    }

    public void updateReference(Reference ref) {
        Preconditions.checkState(this.mutable, "Hash references cannot be updated.");
        this.reference = Preconditions.checkNotNull(ref, "ref is null");
    }

    public String getHash() {
        return this.reference.getHash();
    }

    public Reference getReference() {
        return this.reference;
    }

    public void checkMutable() {
        Preconditions.checkArgument(this.mutable, "You can only mutate tables/views when using a branch without a hash or timestamp.");
    }

    public String getName() {
        return this.reference.getName();
    }

    public boolean isMutable() {
        return this.mutable;
    }
}

