/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iceberg.avro.GenericAvroWriter;
import org.apache.iceberg.encryption.StandardKeyMetadata;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.io.BinaryEncoder;
import org.apache.iceberg.shaded.org.apache.avro.io.DatumWriter;
import org.apache.iceberg.shaded.org.apache.avro.io.EncoderFactory;
import org.apache.iceberg.shaded.org.apache.avro.message.MessageEncoder;

class KeyMetadataEncoder
implements MessageEncoder<StandardKeyMetadata> {
    private static final ThreadLocal<BufferOutputStream> TEMP = ThreadLocal.withInitial(BufferOutputStream::new);
    private static final ThreadLocal<BinaryEncoder> ENCODER = new ThreadLocal();
    private final byte schemaVersion;
    private final boolean copyOutputBytes;
    private final DatumWriter<StandardKeyMetadata> writer;

    KeyMetadataEncoder(byte schemaVersion) {
        this(schemaVersion, true);
    }

    KeyMetadataEncoder(byte schemaVersion, boolean shouldCopy) {
        Schema writeSchema = StandardKeyMetadata.supportedAvroSchemaVersions().get(schemaVersion);
        if (writeSchema == null) {
            throw new UnsupportedOperationException("Cannot resolve schema for version: " + schemaVersion);
        }
        this.writer = GenericAvroWriter.create(writeSchema);
        this.schemaVersion = schemaVersion;
        this.copyOutputBytes = shouldCopy;
    }

    @Override
    public ByteBuffer encode(StandardKeyMetadata datum) throws IOException {
        BufferOutputStream temp = TEMP.get();
        temp.reset();
        temp.write(this.schemaVersion);
        this.encode(datum, (OutputStream)temp);
        if (this.copyOutputBytes) {
            return temp.toBufferWithCopy();
        }
        return temp.toBufferWithoutCopy();
    }

    @Override
    public void encode(StandardKeyMetadata datum, OutputStream stream) throws IOException {
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder(stream, ENCODER.get());
        ENCODER.set(encoder);
        this.writer.write(datum, encoder);
        encoder.flush();
    }

    private static class BufferOutputStream
    extends ByteArrayOutputStream {
        BufferOutputStream() {
        }

        ByteBuffer toBufferWithoutCopy() {
            return ByteBuffer.wrap(this.buf, 0, this.count);
        }

        ByteBuffer toBufferWithCopy() {
            return ByteBuffer.wrap(this.toByteArray());
        }
    }
}

