/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.glue;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.LockManager;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.aws.AwsClientFactories;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.glue.GlueTableOperations;
import org.apache.iceberg.aws.glue.GlueToIcebergConverter;
import org.apache.iceberg.aws.glue.IcebergToGlueConverter;
import org.apache.iceberg.aws.lakeformation.LakeFormationAwsClientFactory;
import org.apache.iceberg.aws.s3.S3FileIOProperties;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hadoop.Configurable;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Cache;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.util.LocationUtil;
import org.apache.iceberg.util.LockManagers;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.Database;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetDatabaseRequest;
import software.amazon.awssdk.services.glue.model.GetDatabaseResponse;
import software.amazon.awssdk.services.glue.model.GetDatabasesRequest;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.glue.model.GetTablesRequest;
import software.amazon.awssdk.services.glue.model.GetTablesResponse;
import software.amazon.awssdk.services.glue.model.InvalidInputException;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.services.glue.model.UpdateDatabaseRequest;

public class GlueCatalog
extends BaseMetastoreCatalog
implements SupportsNamespaces,
Configurable<Configuration> {
    private static final Logger LOG = LoggerFactory.getLogger(GlueCatalog.class);
    private GlueClient glue;
    private Object hadoopConf;
    private String catalogName;
    private String warehousePath;
    private AwsProperties awsProperties;
    private S3FileIOProperties s3FileIOProperties;
    private LockManager lockManager;
    private CloseableGroup closeableGroup;
    private Map<String, String> catalogProperties;
    private Cache<TableOperations, FileIO> fileIOCloser;
    private static final DynMethods.UnboundMethod SET_VERSION_ID = DynMethods.builder("versionId").hiddenImpl("software.amazon.awssdk.services.glue.model.UpdateTableRequest$Builder", String.class).orNoop().build();

    @Override
    public void initialize(String name, Map<String, String> properties) {
        AwsClientFactory awsClientFactory;
        this.catalogProperties = ImmutableMap.copyOf(properties);
        if (PropertyUtil.propertyAsBoolean(properties, "glue.lakeformation-enabled", false)) {
            String factoryImpl = PropertyUtil.propertyAsString(properties, "client.factory", null);
            ImmutableMap.Builder<String, String> builder = ImmutableMap.builder().putAll(properties);
            if (factoryImpl == null) {
                builder.put("client.factory", LakeFormationAwsClientFactory.class.getName());
            }
            this.catalogProperties = builder.buildOrThrow();
            awsClientFactory = AwsClientFactories.from(this.catalogProperties);
            Preconditions.checkArgument(awsClientFactory instanceof LakeFormationAwsClientFactory, "Detected LakeFormation enabled for Glue catalog, should use a client factory that extends %s, but found %s", (Object)LakeFormationAwsClientFactory.class.getName(), (Object)factoryImpl);
        } else {
            awsClientFactory = AwsClientFactories.from(properties);
        }
        this.initialize(name, properties.get("warehouse"), new AwsProperties(properties), new S3FileIOProperties(properties), awsClientFactory.glue(), this.initializeLockManager(properties));
    }

    private LockManager initializeLockManager(Map<String, String> properties) {
        if (properties.containsKey("lock-impl")) {
            return LockManagers.from(properties);
        }
        if (SET_VERSION_ID.isNoop()) {
            LOG.warn("Optimistic locking is not available in the environment. Using in-memory lock manager. To ensure atomic transaction, please configure a distributed lock manager such as the DynamoDB lock manager.");
            return LockManagers.defaultLockManager();
        }
        LOG.debug("Using optimistic locking for Glue Data Catalog tables.");
        return null;
    }

    @VisibleForTesting
    void initialize(String name, String path, AwsProperties properties, S3FileIOProperties s3Properties, GlueClient client, LockManager lock, Map<String, String> catalogProps) {
        this.catalogProperties = catalogProps;
        this.initialize(name, path, properties, s3Properties, client, lock);
    }

    @VisibleForTesting
    void initialize(String name, String path, AwsProperties properties, S3FileIOProperties s3Properties, GlueClient client, LockManager lock) {
        this.catalogName = name;
        this.awsProperties = properties;
        this.s3FileIOProperties = s3Properties;
        this.warehousePath = Strings.isNullOrEmpty(path) ? null : LocationUtil.stripTrailingSlash(path);
        this.glue = client;
        this.lockManager = lock;
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.addCloseable((AutoCloseable)this.glue);
        this.closeableGroup.addCloseable(this.lockManager);
        this.closeableGroup.addCloseable(this.metricsReporter());
        this.closeableGroup.setSuppressCloseFailure(true);
        this.fileIOCloser = this.newFileIOCloser();
    }

    @Override
    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        if (this.catalogProperties != null) {
            ImmutableMap.Builder<String, String> tableSpecificCatalogPropertiesBuilder = ImmutableMap.builder().putAll(this.catalogProperties);
            boolean skipNameValidation = this.awsProperties.glueCatalogSkipNameValidation();
            if (this.s3FileIOProperties.writeTableTagEnabled()) {
                tableSpecificCatalogPropertiesBuilder.put("s3.write.tags.".concat("iceberg.table"), IcebergToGlueConverter.getTableName(tableIdentifier, skipNameValidation));
            }
            if (this.s3FileIOProperties.isWriteNamespaceTagEnabled()) {
                tableSpecificCatalogPropertiesBuilder.put("s3.write.tags.".concat("iceberg.namespace"), IcebergToGlueConverter.getDatabaseName(tableIdentifier, skipNameValidation));
            }
            if (this.awsProperties.glueLakeFormationEnabled()) {
                tableSpecificCatalogPropertiesBuilder.put("lakeformation.db-name", IcebergToGlueConverter.getDatabaseName(tableIdentifier, skipNameValidation)).put("lakeformation.table-name", IcebergToGlueConverter.getTableName(tableIdentifier, skipNameValidation)).put("s3.preload-client-enabled", String.valueOf(true));
            }
            GlueTableOperations glueTableOperations = new GlueTableOperations(this.glue, this.lockManager, this.catalogName, this.awsProperties, tableSpecificCatalogPropertiesBuilder.buildOrThrow(), this.hadoopConf, tableIdentifier);
            this.fileIOCloser.put(glueTableOperations, glueTableOperations.io());
            return glueTableOperations;
        }
        GlueTableOperations glueTableOperations = new GlueTableOperations(this.glue, this.lockManager, this.catalogName, this.awsProperties, this.catalogProperties, this.hadoopConf, tableIdentifier);
        this.fileIOCloser.put(glueTableOperations, glueTableOperations.io());
        return glueTableOperations;
    }

    @Override
    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        GetDatabaseResponse response = this.glue.getDatabase((GetDatabaseRequest)GetDatabaseRequest.builder().catalogId(this.awsProperties.glueCatalogId()).name(IcebergToGlueConverter.getDatabaseName(tableIdentifier, this.awsProperties.glueCatalogSkipNameValidation())).build());
        String dbLocationUri = response.database().locationUri();
        if (dbLocationUri != null) {
            dbLocationUri = LocationUtil.stripTrailingSlash(dbLocationUri);
            return String.format("%s/%s", dbLocationUri, tableIdentifier.name());
        }
        ValidationException.check(!Strings.isNullOrEmpty(this.warehousePath), "Cannot derive default warehouse location, warehouse path must not be null or empty", new Object[0]);
        return String.format("%s/%s.db/%s", this.warehousePath, IcebergToGlueConverter.getDatabaseName(tableIdentifier, this.awsProperties.glueCatalogSkipNameValidation()), tableIdentifier.name());
    }

    @Override
    public List<TableIdentifier> listTables(Namespace namespace) {
        this.namespaceExists(namespace);
        String nextToken = null;
        ArrayList<TableIdentifier> results = Lists.newArrayList();
        do {
            GetTablesResponse response = this.glue.getTables((GetTablesRequest)GetTablesRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(IcebergToGlueConverter.toDatabaseName(namespace, this.awsProperties.glueCatalogSkipNameValidation())).nextToken(nextToken).build());
            nextToken = response.nextToken();
            if (!response.hasTableList()) continue;
            results.addAll(response.tableList().stream().filter(this::isGlueIcebergTable).map(GlueToIcebergConverter::toTableId).collect(Collectors.toList()));
        } while (nextToken != null);
        LOG.debug("Listing of namespace: {} resulted in the following tables: {}", (Object)namespace, results);
        return results;
    }

    private boolean isGlueIcebergTable(Table table) {
        return table.parameters() != null && "iceberg".equalsIgnoreCase((String)table.parameters().get("table_type"));
    }

    @Override
    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        try {
            TableOperations ops = this.newTableOps(identifier);
            TableMetadata lastMetadata = null;
            if (purge) {
                try {
                    lastMetadata = ops.current();
                }
                catch (NotFoundException e) {
                    LOG.warn("Failed to load table metadata for table: {}, continuing drop without purge", (Object)identifier, (Object)e);
                }
            }
            this.glue.deleteTable((DeleteTableRequest)DeleteTableRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(IcebergToGlueConverter.getDatabaseName(identifier, this.awsProperties.glueCatalogSkipNameValidation())).name(identifier.name()).build());
            LOG.info("Successfully dropped table {} from Glue", (Object)identifier);
            if (purge && lastMetadata != null) {
                CatalogUtil.dropTableData(ops.io(), lastMetadata);
                LOG.info("Glue table {} data purged", (Object)identifier);
            }
            LOG.info("Dropped table: {}", (Object)identifier);
            return true;
        }
        catch (EntityNotFoundException e) {
            LOG.error("Cannot drop table {} because table not found or not accessible", (Object)identifier, (Object)e);
            return false;
        }
        catch (Exception e) {
            LOG.error("Cannot complete drop table operation for {} due to unexpected exception", (Object)identifier, (Object)e);
            throw e;
        }
    }

    @Override
    public void renameTable(TableIdentifier from, TableIdentifier to) {
        if (!this.namespaceExists(to.namespace())) {
            throw new NoSuchNamespaceException("Cannot rename %s to %s because namespace %s does not exist", from, to, to.namespace());
        }
        Table fromTable = null;
        String fromTableDbName = IcebergToGlueConverter.getDatabaseName(from, this.awsProperties.glueCatalogSkipNameValidation());
        String fromTableName = IcebergToGlueConverter.getTableName(from, this.awsProperties.glueCatalogSkipNameValidation());
        String toTableDbName = IcebergToGlueConverter.getDatabaseName(to, this.awsProperties.glueCatalogSkipNameValidation());
        String toTableName = IcebergToGlueConverter.getTableName(to, this.awsProperties.glueCatalogSkipNameValidation());
        try {
            GetTableResponse response = this.glue.getTable((GetTableRequest)GetTableRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(fromTableDbName).name(fromTableName).build());
            fromTable = response.table();
        }
        catch (EntityNotFoundException e) {
            throw new NoSuchTableException(e, "Cannot rename %s because the table does not exist in Glue", from);
        }
        TableInput.Builder tableInputBuilder = TableInput.builder().owner(fromTable.owner()).tableType(fromTable.tableType()).parameters(fromTable.parameters()).storageDescriptor(fromTable.storageDescriptor());
        this.glue.createTable((CreateTableRequest)CreateTableRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(toTableDbName).tableInput((TableInput)tableInputBuilder.name(toTableName).build()).build());
        LOG.info("created rename destination table {}", (Object)to);
        try {
            this.dropTable(from, false);
        }
        catch (Exception e) {
            LOG.error("Fail to drop old table {} after renaming to {}, rollback to use the old table", new Object[]{from, to, e});
            this.glue.deleteTable((DeleteTableRequest)DeleteTableRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(toTableDbName).name(toTableName).build());
            throw e;
        }
        LOG.info("Successfully renamed table from {} to {}", (Object)from, (Object)to);
    }

    @Override
    public void createNamespace(Namespace namespace, Map<String, String> metadata) {
        try {
            this.glue.createDatabase((CreateDatabaseRequest)CreateDatabaseRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseInput(IcebergToGlueConverter.toDatabaseInput(namespace, metadata, this.awsProperties.glueCatalogSkipNameValidation())).build());
            LOG.info("Created namespace: {}", (Object)namespace);
        }
        catch (AlreadyExistsException e) {
            throw new org.apache.iceberg.exceptions.AlreadyExistsException("Cannot create namespace %s because it already exists in Glue", namespace);
        }
    }

    @Override
    public List<Namespace> listNamespaces(Namespace namespace) throws NoSuchNamespaceException {
        if (!namespace.isEmpty()) {
            if (this.namespaceExists(namespace)) {
                return Lists.newArrayList();
            }
            throw new NoSuchNamespaceException("Glue does not support nested namespace, cannot list namespaces under %s", namespace);
        }
        String nextToken = null;
        ArrayList<Namespace> results = Lists.newArrayList();
        do {
            GetDatabasesResponse response = this.glue.getDatabases((GetDatabasesRequest)GetDatabasesRequest.builder().catalogId(this.awsProperties.glueCatalogId()).nextToken(nextToken).build());
            nextToken = response.nextToken();
            if (!response.hasDatabaseList()) continue;
            results.addAll(response.databaseList().stream().map(GlueToIcebergConverter::toNamespace).collect(Collectors.toList()));
        } while (nextToken != null);
        LOG.debug("Listing namespace {} returned namespaces: {}", (Object)namespace, results);
        return results;
    }

    @Override
    public Map<String, String> loadNamespaceMetadata(Namespace namespace) throws NoSuchNamespaceException {
        String databaseName = IcebergToGlueConverter.toDatabaseName(namespace, this.awsProperties.glueCatalogSkipNameValidation());
        try {
            Database database = this.glue.getDatabase((GetDatabaseRequest)GetDatabaseRequest.builder().catalogId(this.awsProperties.glueCatalogId()).name(databaseName).build()).database();
            HashMap<String, String> result = Maps.newHashMap(database.parameters());
            if (database.locationUri() != null) {
                result.put("location", LocationUtil.stripTrailingSlash(database.locationUri()));
            }
            if (database.description() != null) {
                result.put("comment", database.description());
            }
            LOG.debug("Loaded metadata for namespace {} found {}", (Object)namespace, result);
            return result;
        }
        catch (InvalidInputException e) {
            throw new NoSuchNamespaceException("invalid input for namespace %s, error message: %s", namespace, e.getMessage());
        }
        catch (EntityNotFoundException e) {
            throw new NoSuchNamespaceException("fail to find Glue database for namespace %s, error message: %s", databaseName, e.getMessage());
        }
    }

    @Override
    public boolean dropNamespace(Namespace namespace) throws NamespaceNotEmptyException {
        this.namespaceExists(namespace);
        GetTablesResponse response = this.glue.getTables((GetTablesRequest)GetTablesRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(IcebergToGlueConverter.toDatabaseName(namespace, this.awsProperties.glueCatalogSkipNameValidation())).build());
        if (response.hasTableList() && !response.tableList().isEmpty()) {
            Table table = (Table)response.tableList().get(0);
            if (this.isGlueIcebergTable(table)) {
                throw new NamespaceNotEmptyException("Cannot drop namespace %s because it still contains Iceberg tables", namespace);
            }
            throw new NamespaceNotEmptyException("Cannot drop namespace %s because it still contains non-Iceberg tables", namespace);
        }
        this.glue.deleteDatabase((DeleteDatabaseRequest)DeleteDatabaseRequest.builder().catalogId(this.awsProperties.glueCatalogId()).name(IcebergToGlueConverter.toDatabaseName(namespace, this.awsProperties.glueCatalogSkipNameValidation())).build());
        LOG.info("Dropped namespace: {}", (Object)namespace);
        return true;
    }

    @Override
    public boolean setProperties(Namespace namespace, Map<String, String> properties) throws NoSuchNamespaceException {
        HashMap<String, String> newProperties = Maps.newHashMap();
        newProperties.putAll(this.loadNamespaceMetadata(namespace));
        newProperties.putAll(properties);
        this.glue.updateDatabase((UpdateDatabaseRequest)UpdateDatabaseRequest.builder().catalogId(this.awsProperties.glueCatalogId()).name(IcebergToGlueConverter.toDatabaseName(namespace, this.awsProperties.glueCatalogSkipNameValidation())).databaseInput(IcebergToGlueConverter.toDatabaseInput(namespace, newProperties, this.awsProperties.glueCatalogSkipNameValidation())).build());
        LOG.debug("Successfully set properties {} for {}", properties.keySet(), (Object)namespace);
        return true;
    }

    @Override
    public boolean removeProperties(Namespace namespace, Set<String> properties) throws NoSuchNamespaceException {
        HashMap<String, String> metadata = Maps.newHashMap(this.loadNamespaceMetadata(namespace));
        for (String property : properties) {
            metadata.remove(property);
        }
        this.glue.updateDatabase((UpdateDatabaseRequest)UpdateDatabaseRequest.builder().catalogId(this.awsProperties.glueCatalogId()).name(IcebergToGlueConverter.toDatabaseName(namespace, this.awsProperties.glueCatalogSkipNameValidation())).databaseInput(IcebergToGlueConverter.toDatabaseInput(namespace, metadata, this.awsProperties.glueCatalogSkipNameValidation())).build());
        LOG.debug("Successfully removed properties {} from {}", properties, (Object)namespace);
        return true;
    }

    @Override
    protected boolean isValidIdentifier(TableIdentifier tableIdentifier) {
        if (this.awsProperties.glueCatalogSkipNameValidation()) {
            return true;
        }
        return IcebergToGlueConverter.isValidNamespace(tableIdentifier.namespace()) && IcebergToGlueConverter.isValidTableName(tableIdentifier.name());
    }

    @Override
    public String name() {
        return this.catalogName;
    }

    @Override
    public void close() throws IOException {
        this.closeableGroup.close();
        if (this.fileIOCloser != null) {
            this.fileIOCloser.invalidateAll();
            this.fileIOCloser.cleanUp();
        }
    }

    @Override
    public void setConf(Configuration conf) {
        this.hadoopConf = conf;
    }

    @Override
    protected Map<String, String> properties() {
        return this.catalogProperties == null ? ImmutableMap.of() : this.catalogProperties;
    }

    private Cache<TableOperations, FileIO> newFileIOCloser() {
        return Caffeine.newBuilder().weakKeys().removalListener((ops, fileIO, cause) -> {
            if (null != fileIO) {
                fileIO.close();
            }
        }).build();
    }
}

