/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.actions.BaseRewriteDataFiles;
import org.apache.iceberg.actions.RewriteDataFiles;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BaseRewriteDataFiles", generator="Immutables")
public final class ImmutableRewriteDataFiles {
    private ImmutableRewriteDataFiles() {
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @CheckReturnValue
    @Generated(from="BaseRewriteDataFiles.FileGroupInfo", generator="Immutables")
    @Immutable
    public static final class FileGroupInfo
    implements BaseRewriteDataFiles.FileGroupInfo {
        private final int globalIndex;
        private final int partitionIndex;
        private final StructLike partition;

        private FileGroupInfo(int globalIndex, int partitionIndex, StructLike partition) {
            this.globalIndex = globalIndex;
            this.partitionIndex = partitionIndex;
            this.partition = partition;
        }

        @Override
        public int globalIndex() {
            return this.globalIndex;
        }

        @Override
        public int partitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public StructLike partition() {
            return this.partition;
        }

        public final FileGroupInfo withGlobalIndex(int value) {
            if (this.globalIndex == value) {
                return this;
            }
            return new FileGroupInfo(value, this.partitionIndex, this.partition);
        }

        public final FileGroupInfo withPartitionIndex(int value) {
            if (this.partitionIndex == value) {
                return this;
            }
            return new FileGroupInfo(this.globalIndex, value, this.partition);
        }

        public final FileGroupInfo withPartition(StructLike value) {
            if (this.partition == value) {
                return this;
            }
            StructLike newValue = Objects.requireNonNull(value, "partition");
            return new FileGroupInfo(this.globalIndex, this.partitionIndex, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FileGroupInfo && this.equalTo(0, (FileGroupInfo)another);
        }

        private boolean equalTo(int synthetic, FileGroupInfo another) {
            return this.globalIndex == another.globalIndex && this.partitionIndex == another.partitionIndex && this.partition.equals(another.partition);
        }

        public int hashCode() {
            int h2 = 5381;
            h2 += (h2 << 5) + this.globalIndex;
            h2 += (h2 << 5) + this.partitionIndex;
            h2 += (h2 << 5) + this.partition.hashCode();
            return h2;
        }

        public String toString() {
            return "FileGroupInfo{globalIndex=" + this.globalIndex + ", partitionIndex=" + this.partitionIndex + ", partition=" + this.partition + "}";
        }

        public static FileGroupInfo copyOf(BaseRewriteDataFiles.FileGroupInfo instance) {
            if (instance instanceof FileGroupInfo) {
                return (FileGroupInfo)instance;
            }
            return FileGroupInfo.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="BaseRewriteDataFiles.FileGroupInfo", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_GLOBAL_INDEX = 1L;
            private static final long INIT_BIT_PARTITION_INDEX = 2L;
            private static final long INIT_BIT_PARTITION = 4L;
            private long initBits = 7L;
            private int globalIndex;
            private int partitionIndex;
            @Nullable
            private StructLike partition;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(BaseRewriteDataFiles.FileGroupInfo instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RewriteDataFiles.FileGroupInfo instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                RewriteDataFiles.FileGroupInfo instance;
                long bits = 0L;
                if (object instanceof BaseRewriteDataFiles.FileGroupInfo) {
                    instance = (BaseRewriteDataFiles.FileGroupInfo)object;
                    if ((bits & 1L) == 0L) {
                        this.partitionIndex(instance.partitionIndex());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.globalIndex(instance.globalIndex());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.partition(instance.partition());
                        bits |= 4L;
                    }
                }
                if (object instanceof RewriteDataFiles.FileGroupInfo) {
                    instance = (RewriteDataFiles.FileGroupInfo)object;
                    if ((bits & 1L) == 0L) {
                        this.partitionIndex(instance.partitionIndex());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.globalIndex(instance.globalIndex());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.partition(instance.partition());
                        bits |= 4L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder globalIndex(int globalIndex) {
                this.globalIndex = globalIndex;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder partitionIndex(int partitionIndex) {
                this.partitionIndex = partitionIndex;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder partition(StructLike partition) {
                this.partition = Objects.requireNonNull(partition, "partition");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public FileGroupInfo build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FileGroupInfo(this.globalIndex, this.partitionIndex, this.partition);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("globalIndex");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("partitionIndex");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("partition");
                }
                return "Cannot build FileGroupInfo, some of required attributes are not set " + attributes;
            }
        }
    }

    @CheckReturnValue
    @Generated(from="BaseRewriteDataFiles.FileGroupFailureResult", generator="Immutables")
    @Immutable
    public static final class FileGroupFailureResult
    implements BaseRewriteDataFiles.FileGroupFailureResult {
        private final RewriteDataFiles.FileGroupInfo info;
        private final int dataFilesCount;

        private FileGroupFailureResult(RewriteDataFiles.FileGroupInfo info, int dataFilesCount) {
            this.info = info;
            this.dataFilesCount = dataFilesCount;
        }

        @Override
        public RewriteDataFiles.FileGroupInfo info() {
            return this.info;
        }

        @Override
        public int dataFilesCount() {
            return this.dataFilesCount;
        }

        public final FileGroupFailureResult withInfo(RewriteDataFiles.FileGroupInfo value) {
            if (this.info == value) {
                return this;
            }
            RewriteDataFiles.FileGroupInfo newValue = Objects.requireNonNull(value, "info");
            return new FileGroupFailureResult(newValue, this.dataFilesCount);
        }

        public final FileGroupFailureResult withDataFilesCount(int value) {
            if (this.dataFilesCount == value) {
                return this;
            }
            return new FileGroupFailureResult(this.info, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FileGroupFailureResult && this.equalTo(0, (FileGroupFailureResult)another);
        }

        private boolean equalTo(int synthetic, FileGroupFailureResult another) {
            return this.info.equals(another.info) && this.dataFilesCount == another.dataFilesCount;
        }

        public int hashCode() {
            int h2 = 5381;
            h2 += (h2 << 5) + this.info.hashCode();
            h2 += (h2 << 5) + this.dataFilesCount;
            return h2;
        }

        public String toString() {
            return "FileGroupFailureResult{info=" + this.info + ", dataFilesCount=" + this.dataFilesCount + "}";
        }

        public static FileGroupFailureResult copyOf(BaseRewriteDataFiles.FileGroupFailureResult instance) {
            if (instance instanceof FileGroupFailureResult) {
                return (FileGroupFailureResult)instance;
            }
            return FileGroupFailureResult.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="BaseRewriteDataFiles.FileGroupFailureResult", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_INFO = 1L;
            private static final long INIT_BIT_DATA_FILES_COUNT = 2L;
            private long initBits = 3L;
            @Nullable
            private RewriteDataFiles.FileGroupInfo info;
            private int dataFilesCount;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(BaseRewriteDataFiles.FileGroupFailureResult instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RewriteDataFiles.FileGroupFailureResult instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                RewriteDataFiles.FileGroupFailureResult instance;
                long bits = 0L;
                if (object instanceof BaseRewriteDataFiles.FileGroupFailureResult) {
                    instance = (BaseRewriteDataFiles.FileGroupFailureResult)object;
                    if ((bits & 1L) == 0L) {
                        this.dataFilesCount(instance.dataFilesCount());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.info(instance.info());
                        bits |= 2L;
                    }
                }
                if (object instanceof RewriteDataFiles.FileGroupFailureResult) {
                    instance = (RewriteDataFiles.FileGroupFailureResult)object;
                    if ((bits & 1L) == 0L) {
                        this.dataFilesCount(instance.dataFilesCount());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.info(instance.info());
                        bits |= 2L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder info(RewriteDataFiles.FileGroupInfo info) {
                this.info = Objects.requireNonNull(info, "info");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder dataFilesCount(int dataFilesCount) {
                this.dataFilesCount = dataFilesCount;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public FileGroupFailureResult build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FileGroupFailureResult(this.info, this.dataFilesCount);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("info");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("dataFilesCount");
                }
                return "Cannot build FileGroupFailureResult, some of required attributes are not set " + attributes;
            }
        }
    }

    @CheckReturnValue
    @Generated(from="BaseRewriteDataFiles.FileGroupRewriteResult", generator="Immutables")
    @Immutable
    public static final class FileGroupRewriteResult
    implements BaseRewriteDataFiles.FileGroupRewriteResult {
        private final RewriteDataFiles.FileGroupInfo info;
        private final int addedDataFilesCount;
        private final int rewrittenDataFilesCount;
        private final long rewrittenBytesCount;

        private FileGroupRewriteResult(Builder builder) {
            this.info = builder.info;
            this.addedDataFilesCount = builder.addedDataFilesCount;
            this.rewrittenDataFilesCount = builder.rewrittenDataFilesCount;
            this.rewrittenBytesCount = builder.rewrittenBytesCountIsSet() ? builder.rewrittenBytesCount : BaseRewriteDataFiles.FileGroupRewriteResult.super.rewrittenBytesCount();
        }

        private FileGroupRewriteResult(RewriteDataFiles.FileGroupInfo info, int addedDataFilesCount, int rewrittenDataFilesCount, long rewrittenBytesCount) {
            this.info = info;
            this.addedDataFilesCount = addedDataFilesCount;
            this.rewrittenDataFilesCount = rewrittenDataFilesCount;
            this.rewrittenBytesCount = rewrittenBytesCount;
        }

        @Override
        public RewriteDataFiles.FileGroupInfo info() {
            return this.info;
        }

        @Override
        public int addedDataFilesCount() {
            return this.addedDataFilesCount;
        }

        @Override
        public int rewrittenDataFilesCount() {
            return this.rewrittenDataFilesCount;
        }

        @Override
        public long rewrittenBytesCount() {
            return this.rewrittenBytesCount;
        }

        public final FileGroupRewriteResult withInfo(RewriteDataFiles.FileGroupInfo value) {
            if (this.info == value) {
                return this;
            }
            RewriteDataFiles.FileGroupInfo newValue = Objects.requireNonNull(value, "info");
            return new FileGroupRewriteResult(newValue, this.addedDataFilesCount, this.rewrittenDataFilesCount, this.rewrittenBytesCount);
        }

        public final FileGroupRewriteResult withAddedDataFilesCount(int value) {
            if (this.addedDataFilesCount == value) {
                return this;
            }
            return new FileGroupRewriteResult(this.info, value, this.rewrittenDataFilesCount, this.rewrittenBytesCount);
        }

        public final FileGroupRewriteResult withRewrittenDataFilesCount(int value) {
            if (this.rewrittenDataFilesCount == value) {
                return this;
            }
            return new FileGroupRewriteResult(this.info, this.addedDataFilesCount, value, this.rewrittenBytesCount);
        }

        public final FileGroupRewriteResult withRewrittenBytesCount(long value) {
            if (this.rewrittenBytesCount == value) {
                return this;
            }
            return new FileGroupRewriteResult(this.info, this.addedDataFilesCount, this.rewrittenDataFilesCount, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FileGroupRewriteResult && this.equalTo(0, (FileGroupRewriteResult)another);
        }

        private boolean equalTo(int synthetic, FileGroupRewriteResult another) {
            return this.info.equals(another.info) && this.addedDataFilesCount == another.addedDataFilesCount && this.rewrittenDataFilesCount == another.rewrittenDataFilesCount && this.rewrittenBytesCount == another.rewrittenBytesCount;
        }

        public int hashCode() {
            int h2 = 5381;
            h2 += (h2 << 5) + this.info.hashCode();
            h2 += (h2 << 5) + this.addedDataFilesCount;
            h2 += (h2 << 5) + this.rewrittenDataFilesCount;
            h2 += (h2 << 5) + Long.hashCode(this.rewrittenBytesCount);
            return h2;
        }

        public String toString() {
            return "FileGroupRewriteResult{info=" + this.info + ", addedDataFilesCount=" + this.addedDataFilesCount + ", rewrittenDataFilesCount=" + this.rewrittenDataFilesCount + ", rewrittenBytesCount=" + this.rewrittenBytesCount + "}";
        }

        public static FileGroupRewriteResult copyOf(BaseRewriteDataFiles.FileGroupRewriteResult instance) {
            if (instance instanceof FileGroupRewriteResult) {
                return (FileGroupRewriteResult)instance;
            }
            return FileGroupRewriteResult.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="BaseRewriteDataFiles.FileGroupRewriteResult", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_INFO = 1L;
            private static final long INIT_BIT_ADDED_DATA_FILES_COUNT = 2L;
            private static final long INIT_BIT_REWRITTEN_DATA_FILES_COUNT = 4L;
            private static final long OPT_BIT_REWRITTEN_BYTES_COUNT = 1L;
            private long initBits = 7L;
            private long optBits;
            @Nullable
            private RewriteDataFiles.FileGroupInfo info;
            private int addedDataFilesCount;
            private int rewrittenDataFilesCount;
            private long rewrittenBytesCount;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(BaseRewriteDataFiles.FileGroupRewriteResult instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RewriteDataFiles.FileGroupRewriteResult instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                RewriteDataFiles.FileGroupRewriteResult instance;
                long bits = 0L;
                if (object instanceof BaseRewriteDataFiles.FileGroupRewriteResult) {
                    instance = (BaseRewriteDataFiles.FileGroupRewriteResult)object;
                    if ((bits & 1L) == 0L) {
                        this.addedDataFilesCount(instance.addedDataFilesCount());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.rewrittenDataFilesCount(instance.rewrittenDataFilesCount());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.info(instance.info());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.rewrittenBytesCount(instance.rewrittenBytesCount());
                        bits |= 8L;
                    }
                }
                if (object instanceof RewriteDataFiles.FileGroupRewriteResult) {
                    instance = (RewriteDataFiles.FileGroupRewriteResult)object;
                    if ((bits & 1L) == 0L) {
                        this.addedDataFilesCount(instance.addedDataFilesCount());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.rewrittenDataFilesCount(instance.rewrittenDataFilesCount());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.info(instance.info());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.rewrittenBytesCount(instance.rewrittenBytesCount());
                        bits |= 8L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder info(RewriteDataFiles.FileGroupInfo info) {
                this.info = Objects.requireNonNull(info, "info");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addedDataFilesCount(int addedDataFilesCount) {
                this.addedDataFilesCount = addedDataFilesCount;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewrittenDataFilesCount(int rewrittenDataFilesCount) {
                this.rewrittenDataFilesCount = rewrittenDataFilesCount;
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewrittenBytesCount(long rewrittenBytesCount) {
                this.rewrittenBytesCount = rewrittenBytesCount;
                this.optBits |= 1L;
                return this;
            }

            public FileGroupRewriteResult build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FileGroupRewriteResult(this);
            }

            private boolean rewrittenBytesCountIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("info");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("addedDataFilesCount");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("rewrittenDataFilesCount");
                }
                return "Cannot build FileGroupRewriteResult, some of required attributes are not set " + attributes;
            }
        }
    }

    @CheckReturnValue
    @Generated(from="BaseRewriteDataFiles.Result", generator="Immutables")
    @Immutable
    public static final class Result
    implements BaseRewriteDataFiles.Result {
        private final List<RewriteDataFiles.FileGroupRewriteResult> rewriteResults;
        private final List<RewriteDataFiles.FileGroupFailureResult> rewriteFailures;
        private final int addedDataFilesCount;
        private final int rewrittenDataFilesCount;
        private final long rewrittenBytesCount;
        private final int failedDataFilesCount;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Result(Builder builder) {
            this.rewriteResults = ImmutableRewriteDataFiles.createUnmodifiableList(true, builder.rewriteResults);
            if (builder.rewriteFailuresIsSet()) {
                this.initShim.rewriteFailures(ImmutableRewriteDataFiles.createUnmodifiableList(true, builder.rewriteFailures));
            }
            if (builder.addedDataFilesCountIsSet()) {
                this.initShim.addedDataFilesCount(builder.addedDataFilesCount);
            }
            if (builder.rewrittenDataFilesCountIsSet()) {
                this.initShim.rewrittenDataFilesCount(builder.rewrittenDataFilesCount);
            }
            if (builder.rewrittenBytesCountIsSet()) {
                this.initShim.rewrittenBytesCount(builder.rewrittenBytesCount);
            }
            if (builder.failedDataFilesCountIsSet()) {
                this.initShim.failedDataFilesCount(builder.failedDataFilesCount);
            }
            this.rewriteFailures = this.initShim.rewriteFailures();
            this.addedDataFilesCount = this.initShim.addedDataFilesCount();
            this.rewrittenDataFilesCount = this.initShim.rewrittenDataFilesCount();
            this.rewrittenBytesCount = this.initShim.rewrittenBytesCount();
            this.failedDataFilesCount = this.initShim.failedDataFilesCount();
            this.initShim = null;
        }

        private Result(List<RewriteDataFiles.FileGroupRewriteResult> rewriteResults, List<RewriteDataFiles.FileGroupFailureResult> rewriteFailures, int addedDataFilesCount, int rewrittenDataFilesCount, long rewrittenBytesCount, int failedDataFilesCount) {
            this.rewriteResults = rewriteResults;
            this.rewriteFailures = rewriteFailures;
            this.addedDataFilesCount = addedDataFilesCount;
            this.rewrittenDataFilesCount = rewrittenDataFilesCount;
            this.rewrittenBytesCount = rewrittenBytesCount;
            this.failedDataFilesCount = failedDataFilesCount;
            this.initShim = null;
        }

        private List<RewriteDataFiles.FileGroupFailureResult> rewriteFailuresInitialize() {
            return BaseRewriteDataFiles.Result.super.rewriteFailures();
        }

        private int addedDataFilesCountInitialize() {
            return BaseRewriteDataFiles.Result.super.addedDataFilesCount();
        }

        private int rewrittenDataFilesCountInitialize() {
            return BaseRewriteDataFiles.Result.super.rewrittenDataFilesCount();
        }

        private long rewrittenBytesCountInitialize() {
            return BaseRewriteDataFiles.Result.super.rewrittenBytesCount();
        }

        private int failedDataFilesCountInitialize() {
            return BaseRewriteDataFiles.Result.super.failedDataFilesCount();
        }

        @Override
        public List<RewriteDataFiles.FileGroupRewriteResult> rewriteResults() {
            return this.rewriteResults;
        }

        @Override
        public List<RewriteDataFiles.FileGroupFailureResult> rewriteFailures() {
            InitShim shim = this.initShim;
            return shim != null ? shim.rewriteFailures() : this.rewriteFailures;
        }

        @Override
        public int addedDataFilesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.addedDataFilesCount() : this.addedDataFilesCount;
        }

        @Override
        public int rewrittenDataFilesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.rewrittenDataFilesCount() : this.rewrittenDataFilesCount;
        }

        @Override
        public long rewrittenBytesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.rewrittenBytesCount() : this.rewrittenBytesCount;
        }

        @Override
        public int failedDataFilesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.failedDataFilesCount() : this.failedDataFilesCount;
        }

        public final Result withRewriteResults(RewriteDataFiles.FileGroupRewriteResult ... elements) {
            List newValue = ImmutableRewriteDataFiles.createUnmodifiableList(false, ImmutableRewriteDataFiles.createSafeList(Arrays.asList(elements), true, false));
            return new Result(newValue, this.rewriteFailures, this.addedDataFilesCount, this.rewrittenDataFilesCount, this.rewrittenBytesCount, this.failedDataFilesCount);
        }

        public final Result withRewriteResults(Iterable<? extends RewriteDataFiles.FileGroupRewriteResult> elements) {
            if (this.rewriteResults == elements) {
                return this;
            }
            List newValue = ImmutableRewriteDataFiles.createUnmodifiableList(false, ImmutableRewriteDataFiles.createSafeList(elements, true, false));
            return new Result(newValue, this.rewriteFailures, this.addedDataFilesCount, this.rewrittenDataFilesCount, this.rewrittenBytesCount, this.failedDataFilesCount);
        }

        public final Result withRewriteFailures(RewriteDataFiles.FileGroupFailureResult ... elements) {
            List newValue = ImmutableRewriteDataFiles.createUnmodifiableList(false, ImmutableRewriteDataFiles.createSafeList(Arrays.asList(elements), true, false));
            return new Result(this.rewriteResults, newValue, this.addedDataFilesCount, this.rewrittenDataFilesCount, this.rewrittenBytesCount, this.failedDataFilesCount);
        }

        public final Result withRewriteFailures(Iterable<? extends RewriteDataFiles.FileGroupFailureResult> elements) {
            if (this.rewriteFailures == elements) {
                return this;
            }
            List newValue = ImmutableRewriteDataFiles.createUnmodifiableList(false, ImmutableRewriteDataFiles.createSafeList(elements, true, false));
            return new Result(this.rewriteResults, newValue, this.addedDataFilesCount, this.rewrittenDataFilesCount, this.rewrittenBytesCount, this.failedDataFilesCount);
        }

        public final Result withAddedDataFilesCount(int value) {
            if (this.addedDataFilesCount == value) {
                return this;
            }
            return new Result(this.rewriteResults, this.rewriteFailures, value, this.rewrittenDataFilesCount, this.rewrittenBytesCount, this.failedDataFilesCount);
        }

        public final Result withRewrittenDataFilesCount(int value) {
            if (this.rewrittenDataFilesCount == value) {
                return this;
            }
            return new Result(this.rewriteResults, this.rewriteFailures, this.addedDataFilesCount, value, this.rewrittenBytesCount, this.failedDataFilesCount);
        }

        public final Result withRewrittenBytesCount(long value) {
            if (this.rewrittenBytesCount == value) {
                return this;
            }
            return new Result(this.rewriteResults, this.rewriteFailures, this.addedDataFilesCount, this.rewrittenDataFilesCount, value, this.failedDataFilesCount);
        }

        public final Result withFailedDataFilesCount(int value) {
            if (this.failedDataFilesCount == value) {
                return this;
            }
            return new Result(this.rewriteResults, this.rewriteFailures, this.addedDataFilesCount, this.rewrittenDataFilesCount, this.rewrittenBytesCount, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Result && this.equalTo(0, (Result)another);
        }

        private boolean equalTo(int synthetic, Result another) {
            return this.rewriteResults.equals(another.rewriteResults) && this.rewriteFailures.equals(another.rewriteFailures) && this.addedDataFilesCount == another.addedDataFilesCount && this.rewrittenDataFilesCount == another.rewrittenDataFilesCount && this.rewrittenBytesCount == another.rewrittenBytesCount && this.failedDataFilesCount == another.failedDataFilesCount;
        }

        public int hashCode() {
            int h2 = 5381;
            h2 += (h2 << 5) + this.rewriteResults.hashCode();
            h2 += (h2 << 5) + this.rewriteFailures.hashCode();
            h2 += (h2 << 5) + this.addedDataFilesCount;
            h2 += (h2 << 5) + this.rewrittenDataFilesCount;
            h2 += (h2 << 5) + Long.hashCode(this.rewrittenBytesCount);
            h2 += (h2 << 5) + this.failedDataFilesCount;
            return h2;
        }

        public String toString() {
            return "Result{rewriteResults=" + this.rewriteResults + ", rewriteFailures=" + this.rewriteFailures + ", addedDataFilesCount=" + this.addedDataFilesCount + ", rewrittenDataFilesCount=" + this.rewrittenDataFilesCount + ", rewrittenBytesCount=" + this.rewrittenBytesCount + ", failedDataFilesCount=" + this.failedDataFilesCount + "}";
        }

        public static Result copyOf(BaseRewriteDataFiles.Result instance) {
            if (instance instanceof Result) {
                return (Result)instance;
            }
            return Result.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="BaseRewriteDataFiles.Result", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long OPT_BIT_REWRITE_FAILURES = 1L;
            private static final long OPT_BIT_ADDED_DATA_FILES_COUNT = 2L;
            private static final long OPT_BIT_REWRITTEN_DATA_FILES_COUNT = 4L;
            private static final long OPT_BIT_REWRITTEN_BYTES_COUNT = 8L;
            private static final long OPT_BIT_FAILED_DATA_FILES_COUNT = 16L;
            private long optBits;
            private List<RewriteDataFiles.FileGroupRewriteResult> rewriteResults = new ArrayList<RewriteDataFiles.FileGroupRewriteResult>();
            private List<RewriteDataFiles.FileGroupFailureResult> rewriteFailures = new ArrayList<RewriteDataFiles.FileGroupFailureResult>();
            private int addedDataFilesCount;
            private int rewrittenDataFilesCount;
            private long rewrittenBytesCount;
            private int failedDataFilesCount;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(BaseRewriteDataFiles.Result instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RewriteDataFiles.Result instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                RewriteDataFiles.Result instance;
                long bits = 0L;
                if (object instanceof BaseRewriteDataFiles.Result) {
                    instance = (BaseRewriteDataFiles.Result)object;
                    if ((bits & 8L) == 0L) {
                        this.addedDataFilesCount(instance.addedDataFilesCount());
                        bits |= 8L;
                    }
                    if ((bits & 1L) == 0L) {
                        this.failedDataFilesCount(instance.failedDataFilesCount());
                        bits |= 1L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.rewrittenDataFilesCount(instance.rewrittenDataFilesCount());
                        bits |= 0x10L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.addAllRewriteFailures(instance.rewriteFailures());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.addAllRewriteResults(instance.rewriteResults());
                        bits |= 4L;
                    }
                    if ((bits & 0x20L) == 0L) {
                        this.rewrittenBytesCount(instance.rewrittenBytesCount());
                        bits |= 0x20L;
                    }
                }
                if (object instanceof RewriteDataFiles.Result) {
                    instance = (RewriteDataFiles.Result)object;
                    if ((bits & 8L) == 0L) {
                        this.addedDataFilesCount(instance.addedDataFilesCount());
                        bits |= 8L;
                    }
                    if ((bits & 1L) == 0L) {
                        this.failedDataFilesCount(instance.failedDataFilesCount());
                        bits |= 1L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.rewrittenDataFilesCount(instance.rewrittenDataFilesCount());
                        bits |= 0x10L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.addAllRewriteFailures(instance.rewriteFailures());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.addAllRewriteResults(instance.rewriteResults());
                        bits |= 4L;
                    }
                    if ((bits & 0x20L) == 0L) {
                        this.rewrittenBytesCount(instance.rewrittenBytesCount());
                        bits |= 0x20L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder addRewriteResults(RewriteDataFiles.FileGroupRewriteResult element) {
                this.rewriteResults.add(Objects.requireNonNull(element, "rewriteResults element"));
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addRewriteResults(RewriteDataFiles.FileGroupRewriteResult ... elements) {
                for (RewriteDataFiles.FileGroupRewriteResult element : elements) {
                    this.rewriteResults.add(Objects.requireNonNull(element, "rewriteResults element"));
                }
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewriteResults(Iterable<? extends RewriteDataFiles.FileGroupRewriteResult> elements) {
                this.rewriteResults.clear();
                return this.addAllRewriteResults(elements);
            }

            @CanIgnoreReturnValue
            public final Builder addAllRewriteResults(Iterable<? extends RewriteDataFiles.FileGroupRewriteResult> elements) {
                for (RewriteDataFiles.FileGroupRewriteResult fileGroupRewriteResult : elements) {
                    this.rewriteResults.add(Objects.requireNonNull(fileGroupRewriteResult, "rewriteResults element"));
                }
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addRewriteFailures(RewriteDataFiles.FileGroupFailureResult element) {
                this.rewriteFailures.add(Objects.requireNonNull(element, "rewriteFailures element"));
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addRewriteFailures(RewriteDataFiles.FileGroupFailureResult ... elements) {
                for (RewriteDataFiles.FileGroupFailureResult element : elements) {
                    this.rewriteFailures.add(Objects.requireNonNull(element, "rewriteFailures element"));
                }
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewriteFailures(Iterable<? extends RewriteDataFiles.FileGroupFailureResult> elements) {
                this.rewriteFailures.clear();
                return this.addAllRewriteFailures(elements);
            }

            @CanIgnoreReturnValue
            public final Builder addAllRewriteFailures(Iterable<? extends RewriteDataFiles.FileGroupFailureResult> elements) {
                for (RewriteDataFiles.FileGroupFailureResult fileGroupFailureResult : elements) {
                    this.rewriteFailures.add(Objects.requireNonNull(fileGroupFailureResult, "rewriteFailures element"));
                }
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addedDataFilesCount(int addedDataFilesCount) {
                this.addedDataFilesCount = addedDataFilesCount;
                this.optBits |= 2L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewrittenDataFilesCount(int rewrittenDataFilesCount) {
                this.rewrittenDataFilesCount = rewrittenDataFilesCount;
                this.optBits |= 4L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewrittenBytesCount(long rewrittenBytesCount) {
                this.rewrittenBytesCount = rewrittenBytesCount;
                this.optBits |= 8L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder failedDataFilesCount(int failedDataFilesCount) {
                this.failedDataFilesCount = failedDataFilesCount;
                this.optBits |= 0x10L;
                return this;
            }

            public Result build() {
                return new Result(this);
            }

            private boolean rewriteFailuresIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private boolean addedDataFilesCountIsSet() {
                return (this.optBits & 2L) != 0L;
            }

            private boolean rewrittenDataFilesCountIsSet() {
                return (this.optBits & 4L) != 0L;
            }

            private boolean rewrittenBytesCountIsSet() {
                return (this.optBits & 8L) != 0L;
            }

            private boolean failedDataFilesCountIsSet() {
                return (this.optBits & 0x10L) != 0L;
            }
        }

        @Generated(from="BaseRewriteDataFiles.Result", generator="Immutables")
        private final class InitShim {
            private byte rewriteFailuresBuildStage = 0;
            private List<RewriteDataFiles.FileGroupFailureResult> rewriteFailures;
            private byte addedDataFilesCountBuildStage = 0;
            private int addedDataFilesCount;
            private byte rewrittenDataFilesCountBuildStage = 0;
            private int rewrittenDataFilesCount;
            private byte rewrittenBytesCountBuildStage = 0;
            private long rewrittenBytesCount;
            private byte failedDataFilesCountBuildStage = 0;
            private int failedDataFilesCount;

            private InitShim() {
            }

            List<RewriteDataFiles.FileGroupFailureResult> rewriteFailures() {
                if (this.rewriteFailuresBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.rewriteFailuresBuildStage == 0) {
                    this.rewriteFailuresBuildStage = (byte)-1;
                    this.rewriteFailures = ImmutableRewriteDataFiles.createUnmodifiableList(false, ImmutableRewriteDataFiles.createSafeList(Result.this.rewriteFailuresInitialize(), true, false));
                    this.rewriteFailuresBuildStage = 1;
                }
                return this.rewriteFailures;
            }

            void rewriteFailures(List<RewriteDataFiles.FileGroupFailureResult> rewriteFailures) {
                this.rewriteFailures = rewriteFailures;
                this.rewriteFailuresBuildStage = 1;
            }

            int addedDataFilesCount() {
                if (this.addedDataFilesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.addedDataFilesCountBuildStage == 0) {
                    this.addedDataFilesCountBuildStage = (byte)-1;
                    this.addedDataFilesCount = Result.this.addedDataFilesCountInitialize();
                    this.addedDataFilesCountBuildStage = 1;
                }
                return this.addedDataFilesCount;
            }

            void addedDataFilesCount(int addedDataFilesCount) {
                this.addedDataFilesCount = addedDataFilesCount;
                this.addedDataFilesCountBuildStage = 1;
            }

            int rewrittenDataFilesCount() {
                if (this.rewrittenDataFilesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.rewrittenDataFilesCountBuildStage == 0) {
                    this.rewrittenDataFilesCountBuildStage = (byte)-1;
                    this.rewrittenDataFilesCount = Result.this.rewrittenDataFilesCountInitialize();
                    this.rewrittenDataFilesCountBuildStage = 1;
                }
                return this.rewrittenDataFilesCount;
            }

            void rewrittenDataFilesCount(int rewrittenDataFilesCount) {
                this.rewrittenDataFilesCount = rewrittenDataFilesCount;
                this.rewrittenDataFilesCountBuildStage = 1;
            }

            long rewrittenBytesCount() {
                if (this.rewrittenBytesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.rewrittenBytesCountBuildStage == 0) {
                    this.rewrittenBytesCountBuildStage = (byte)-1;
                    this.rewrittenBytesCount = Result.this.rewrittenBytesCountInitialize();
                    this.rewrittenBytesCountBuildStage = 1;
                }
                return this.rewrittenBytesCount;
            }

            void rewrittenBytesCount(long rewrittenBytesCount) {
                this.rewrittenBytesCount = rewrittenBytesCount;
                this.rewrittenBytesCountBuildStage = 1;
            }

            int failedDataFilesCount() {
                if (this.failedDataFilesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.failedDataFilesCountBuildStage == 0) {
                    this.failedDataFilesCountBuildStage = (byte)-1;
                    this.failedDataFilesCount = Result.this.failedDataFilesCountInitialize();
                    this.failedDataFilesCountBuildStage = 1;
                }
                return this.failedDataFilesCount;
            }

            void failedDataFilesCount(int failedDataFilesCount) {
                this.failedDataFilesCount = failedDataFilesCount;
                this.failedDataFilesCountBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.rewriteFailuresBuildStage == -1) {
                    attributes.add("rewriteFailures");
                }
                if (this.addedDataFilesCountBuildStage == -1) {
                    attributes.add("addedDataFilesCount");
                }
                if (this.rewrittenDataFilesCountBuildStage == -1) {
                    attributes.add("rewrittenDataFilesCount");
                }
                if (this.rewrittenBytesCountBuildStage == -1) {
                    attributes.add("rewrittenBytesCount");
                }
                if (this.failedDataFilesCountBuildStage == -1) {
                    attributes.add("failedDataFilesCount");
                }
                return "Cannot build Result, attribute initializers form cycle " + attributes;
            }
        }
    }
}

