/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;

public abstract class BaseHttpRequest
extends HttpRequest {
    private static final TypeReference<Map<String, Object>> MAP_TYPE = new TypeReference<Map<String, Object>>(){};

    protected BaseHttpRequest(HttpRuntimeConfig config, URI baseUri) {
        super(config, baseUri);
    }

    protected boolean prepareRequest(RequestContext context) {
        boolean doesOutput;
        boolean postOrPut;
        this.headers.put("Accept", this.accept);
        HttpClient.Method method = context.getMethod();
        boolean bl = postOrPut = method == HttpClient.Method.PUT || method == HttpClient.Method.POST;
        if (postOrPut) {
            this.headers.put("Content-Type", this.contentsType);
        }
        boolean bl2 = doesOutput = postOrPut && context.getBody().isPresent();
        if (!this.config.isDisableCompression()) {
            this.headers.put("Accept-Encoding", "gzip;q=1.0, deflate;q=0.9");
            if (doesOutput) {
                this.headers.put("Content-Encoding", "gzip");
            }
        }
        this.config.getRequestFilters().forEach(a -> a.filter(context));
        HttpAuthentication auth = this.auth;
        if (auth != null) {
            auth.applyToHttpRequest(context);
            auth.start();
        }
        return doesOutput;
    }

    protected void cleanUp() {
        HttpAuthentication auth = this.auth;
        if (auth != null) {
            auth.close();
        }
    }

    protected void writeToOutputStream(RequestContext context, OutputStream outputStream) throws IOException {
        Object body = context.getBody().orElseThrow(NullPointerException::new);
        try (OutputStream out = this.wrapOutputStream(outputStream);){
            if (context.isFormEncoded()) {
                this.writeFormData(out, body);
            } else {
                this.writeBody(out, body);
            }
        }
        catch (JsonGenerationException | JsonMappingException e) {
            throw new HttpClientException(String.format("Cannot serialize body of %s request against '%s'. Unable to serialize %s", new Object[]{context.getMethod(), context.getUri(), body.getClass()}), e);
        }
    }

    private OutputStream wrapOutputStream(OutputStream base) throws IOException {
        return this.config.isDisableCompression() ? base : new GZIPOutputStream(base);
    }

    private void writeBody(OutputStream out, Object body) throws IOException {
        Class<?> bodyType = body.getClass();
        if (bodyType != String.class) {
            ObjectWriter writer = this.config.getMapper().writer();
            if (this.config.getJsonView() != null) {
                writer = writer.withView(this.config.getJsonView());
            }
            writer.forType(bodyType).writeValue(out, body);
        } else {
            out.write(((String)body).getBytes(StandardCharsets.UTF_8));
        }
    }

    private void writeFormData(OutputStream out, Object body) throws IOException {
        ObjectMapper mapper = this.config.getMapper();
        Map<String, Object> map = mapper.convertValue(body, MAP_TYPE);
        boolean first = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            if (!first) {
                out.write(38);
            } else {
                first = false;
            }
            String key = URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.name());
            String value = URLEncoder.encode(mapper.convertValue(entry.getValue(), String.class), StandardCharsets.UTF_8.name());
            out.write(key.getBytes(StandardCharsets.UTF_8));
            out.write(61);
            out.write(value.getBytes(StandardCharsets.UTF_8));
        }
    }
}

