/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class Secret {
    final char[] value;

    public Secret(char ... value) {
        this.value = value;
    }

    public Secret(String value) {
        this.value = value.toCharArray();
    }

    public int length() {
        return this.value.length;
    }

    public char[] getCharsAndClear() {
        char[] v = (char[])this.value.clone();
        Arrays.fill(this.value, '\u0000');
        return v;
    }

    public String getStringAndClear() {
        String s2 = new String(this.value);
        Arrays.fill(this.value, '\u0000');
        return s2;
    }

    public byte[] getBytesAndClear(Charset charset) {
        CharBuffer cb = CharBuffer.wrap(this.value);
        ByteBuffer bb = charset.encode(cb);
        byte[] bytes = new byte[bb.remaining()];
        bb.get(bytes);
        if (bb.hasArray()) {
            Arrays.fill(bb.array(), (byte)0);
        }
        Arrays.fill(this.value, '\u0000');
        return bytes;
    }
}

