/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.ErrorResponse;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ErrorResponse", generator="Immutables")
@Immutable
final class ImmutableErrorResponse
implements ErrorResponse {
    private final String errorCode;
    @Nullable
    private final String errorDescription;

    private ImmutableErrorResponse(String errorCode, @Nullable String errorDescription) {
        this.errorCode = errorCode;
        this.errorDescription = errorDescription;
    }

    @Override
    @JsonProperty(value="error")
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="error_description")
    @Nullable
    public String getErrorDescription() {
        return this.errorDescription;
    }

    public final ImmutableErrorResponse withErrorCode(String value) {
        String newValue = Objects.requireNonNull(value, "errorCode");
        if (this.errorCode.equals(newValue)) {
            return this;
        }
        return new ImmutableErrorResponse(newValue, this.errorDescription);
    }

    public final ImmutableErrorResponse withErrorDescription(@Nullable String value) {
        if (Objects.equals(this.errorDescription, value)) {
            return this;
        }
        return new ImmutableErrorResponse(this.errorCode, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorResponse && this.equalTo(0, (ImmutableErrorResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableErrorResponse another) {
        return this.errorCode.equals(another.errorCode) && Objects.equals(this.errorDescription, another.errorDescription);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.errorCode.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.errorDescription);
        return h2;
    }

    public String toString() {
        return "ErrorResponse{errorCode=" + this.errorCode + ", errorDescription=" + this.errorDescription + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableErrorResponse fromJson(Json json) {
        Builder builder = ImmutableErrorResponse.builder();
        if (json.errorCode != null) {
            builder.errorCode(json.errorCode);
        }
        if (json.errorDescription != null) {
            builder.errorDescription(json.errorDescription);
        }
        return builder.build();
    }

    public static ImmutableErrorResponse copyOf(ErrorResponse instance) {
        if (instance instanceof ImmutableErrorResponse) {
            return (ImmutableErrorResponse)instance;
        }
        return ImmutableErrorResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ErrorResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ERROR_CODE = 1L;
        private long initBits = 1L;
        @Nullable
        private String errorCode;
        @Nullable
        private String errorDescription;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ErrorResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.errorCode(instance.getErrorCode());
            String errorDescriptionValue = instance.getErrorDescription();
            if (errorDescriptionValue != null) {
                this.errorDescription(errorDescriptionValue);
            }
            return this;
        }

        @JsonProperty(value="error")
        @CanIgnoreReturnValue
        public final Builder errorCode(String errorCode) {
            this.errorCode = Objects.requireNonNull(errorCode, "errorCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="error_description")
        @CanIgnoreReturnValue
        public final Builder errorDescription(@Nullable String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        public ImmutableErrorResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableErrorResponse(this.errorCode, this.errorDescription);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("errorCode");
            }
            return "Cannot build ErrorResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ErrorResponse", generator="Immutables")
    static final class Json
    implements ErrorResponse {
        @Nullable
        String errorCode;
        @Nullable
        String errorDescription;

        Json() {
        }

        @JsonProperty(value="error")
        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @JsonProperty(value="error_description")
        public void setErrorDescription(@Nullable String errorDescription) {
            this.errorDescription = errorDescription;
        }

        @Override
        public String getErrorCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getErrorDescription() {
            throw new UnsupportedOperationException();
        }
    }
}

