/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.DeviceCodeTokensRequest;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.TokensRequestBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeviceCodeTokensRequest", generator="Immutables")
@Immutable
final class ImmutableDeviceCodeTokensRequest
implements DeviceCodeTokensRequest {
    @Nullable
    private final String scope;
    private final GrantType grantType;
    private final String deviceCode;
    @Nullable
    private final String clientId;

    private ImmutableDeviceCodeTokensRequest(Builder builder) {
        this.scope = builder.scope;
        this.deviceCode = builder.deviceCode;
        this.clientId = builder.clientId;
        this.grantType = builder.grantType != null ? builder.grantType : Objects.requireNonNull(DeviceCodeTokensRequest.super.getGrantType(), "grantType");
    }

    private ImmutableDeviceCodeTokensRequest(@Nullable String scope, GrantType grantType, String deviceCode, @Nullable String clientId) {
        this.scope = scope;
        this.grantType = grantType;
        this.deviceCode = deviceCode;
        this.clientId = clientId;
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="grant_type")
    public GrantType getGrantType() {
        return this.grantType;
    }

    @Override
    @JsonProperty(value="device_code")
    public String getDeviceCode() {
        return this.deviceCode;
    }

    @Override
    @JsonProperty(value="client_id")
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    public final ImmutableDeviceCodeTokensRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableDeviceCodeTokensRequest(value, this.grantType, this.deviceCode, this.clientId);
    }

    public final ImmutableDeviceCodeTokensRequest withGrantType(GrantType value) {
        GrantType newValue = Objects.requireNonNull(value, "grantType");
        if (this.grantType == newValue) {
            return this;
        }
        return new ImmutableDeviceCodeTokensRequest(this.scope, newValue, this.deviceCode, this.clientId);
    }

    public final ImmutableDeviceCodeTokensRequest withDeviceCode(String value) {
        String newValue = Objects.requireNonNull(value, "deviceCode");
        if (this.deviceCode.equals(newValue)) {
            return this;
        }
        return new ImmutableDeviceCodeTokensRequest(this.scope, this.grantType, newValue, this.clientId);
    }

    public final ImmutableDeviceCodeTokensRequest withClientId(@Nullable String value) {
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutableDeviceCodeTokensRequest(this.scope, this.grantType, this.deviceCode, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeviceCodeTokensRequest && this.equalTo(0, (ImmutableDeviceCodeTokensRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeviceCodeTokensRequest another) {
        return Objects.equals(this.scope, another.scope) && this.grantType.equals((Object)another.grantType) && this.deviceCode.equals(another.deviceCode) && Objects.equals(this.clientId, another.clientId);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.scope);
        h2 += (h2 << 5) + this.grantType.hashCode();
        h2 += (h2 << 5) + this.deviceCode.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.clientId);
        return h2;
    }

    public String toString() {
        return "DeviceCodeTokensRequest{scope=" + this.scope + ", grantType=" + (Object)((Object)this.grantType) + ", deviceCode=" + this.deviceCode + ", clientId=" + this.clientId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDeviceCodeTokensRequest fromJson(Json json) {
        Builder builder = ImmutableDeviceCodeTokensRequest.builder();
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.grantType != null) {
            builder.grantType(json.grantType);
        }
        if (json.deviceCode != null) {
            builder.deviceCode(json.deviceCode);
        }
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        return builder.build();
    }

    public static ImmutableDeviceCodeTokensRequest copyOf(DeviceCodeTokensRequest instance) {
        if (instance instanceof ImmutableDeviceCodeTokensRequest) {
            return (ImmutableDeviceCodeTokensRequest)instance;
        }
        return ImmutableDeviceCodeTokensRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeviceCodeTokensRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DEVICE_CODE = 1L;
        private long initBits = 1L;
        @Nullable
        private String scope;
        @Nullable
        private GrantType grantType;
        @Nullable
        private String deviceCode;
        @Nullable
        private String clientId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeviceCodeTokensRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokensRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            TokensRequestBase instance;
            long bits = 0L;
            if (object instanceof DeviceCodeTokensRequest) {
                instance = (DeviceCodeTokensRequest)object;
                String clientIdValue = instance.getClientId();
                if (clientIdValue != null) {
                    this.clientId(clientIdValue);
                }
                this.deviceCode(instance.getDeviceCode());
                if ((bits & 2L) == 0L) {
                    this.grantType(instance.getGrantType());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    String scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof TokensRequestBase) {
                instance = (TokensRequestBase)object;
                if ((bits & 2L) == 0L) {
                    this.grantType(instance.getGrantType());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    String scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonProperty(value="grant_type")
        @CanIgnoreReturnValue
        public final Builder grantType(GrantType grantType) {
            this.grantType = Objects.requireNonNull(grantType, "grantType");
            return this;
        }

        @JsonProperty(value="device_code")
        @CanIgnoreReturnValue
        public final Builder deviceCode(String deviceCode) {
            this.deviceCode = Objects.requireNonNull(deviceCode, "deviceCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="client_id")
        @CanIgnoreReturnValue
        public final Builder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        public ImmutableDeviceCodeTokensRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeviceCodeTokensRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("deviceCode");
            }
            return "Cannot build DeviceCodeTokensRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DeviceCodeTokensRequest", generator="Immutables")
    static final class Json
    implements DeviceCodeTokensRequest {
        @Nullable
        String scope;
        @Nullable
        GrantType grantType;
        @Nullable
        String deviceCode;
        @Nullable
        String clientId;

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @JsonProperty(value="grant_type")
        public void setGrantType(GrantType grantType) {
            this.grantType = grantType;
        }

        @JsonProperty(value="device_code")
        public void setDeviceCode(String deviceCode) {
            this.deviceCode = deviceCode;
        }

        @JsonProperty(value="client_id")
        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GrantType getGrantType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDeviceCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }
    }
}

