/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.objects;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.ints.IntCollection;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.ints.IntIterator;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.objects.AbstractObject2IntFunction;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.objects.Object2IntMaps;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.objects.ObjectSet;

public abstract class AbstractObject2IntMap<K>
extends AbstractObject2IntFunction<K>
implements Object2IntMap<K>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractObject2IntMap() {
    }

    @Override
    public boolean containsValue(int v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(Object k) {
        Iterator i = this.object2IntEntrySet().iterator();
        while (i.hasNext()) {
            if (((Object2IntMap.Entry)i.next()).getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ObjectSet<K> keySet() {
        return new AbstractObjectSet<K>(){

            @Override
            public boolean contains(Object k) {
                return AbstractObject2IntMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractObject2IntMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2IntMap.this.clear();
            }

            @Override
            public ObjectIterator<K> iterator() {
                return new ObjectIterator<K>(){
                    private final ObjectIterator<Object2IntMap.Entry<K>> i;
                    {
                        this.i = Object2IntMaps.fastIterator(AbstractObject2IntMap.this);
                    }

                    @Override
                    public K next() {
                        return ((Object2IntMap.Entry)this.i.next()).getKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public IntCollection values() {
        return new AbstractIntCollection(){

            @Override
            public boolean contains(int k) {
                return AbstractObject2IntMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractObject2IntMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2IntMap.this.clear();
            }

            @Override
            public IntIterator iterator() {
                return new IntIterator(){
                    private final ObjectIterator<Object2IntMap.Entry<K>> i;
                    {
                        this.i = Object2IntMaps.fastIterator(AbstractObject2IntMap.this);
                    }

                    @Override
                    public int nextInt() {
                        return ((Object2IntMap.Entry)this.i.next()).getIntValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends K, ? extends Integer> m4) {
        if (m4 instanceof Object2IntMap) {
            ObjectIterator i = Object2IntMaps.fastIterator((Object2IntMap)m4);
            while (i.hasNext()) {
                Object2IntMap.Entry e = (Object2IntMap.Entry)i.next();
                this.put(e.getKey(), e.getIntValue());
            }
        } else {
            int n = m4.size();
            Iterator<Map.Entry<K, Integer>> i = m4.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<K, Integer> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n = this.size();
        ObjectIterator i = Object2IntMaps.fastIterator(this);
        while (n-- != 0) {
            h2 += ((Object2IntMap.Entry)i.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m4 = (Map)o;
        if (m4.size() != this.size()) {
            return false;
        }
        return this.object2IntEntrySet().containsAll(m4.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i = Object2IntMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s2.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Object2IntMap.Entry e = (Object2IntMap.Entry)i.next();
            if (this == e.getKey()) {
                s2.append("(this map)");
            } else {
                s2.append(String.valueOf(e.getKey()));
            }
            s2.append("=>");
            s2.append(String.valueOf(e.getIntValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet<K>
    extends AbstractObjectSet<Object2IntMap.Entry<K>> {
        protected final Object2IntMap<K> map;

        public BasicEntrySet(Object2IntMap<K> map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Object2IntMap.Entry) {
                Object2IntMap.Entry e = (Object2IntMap.Entry)o;
                Object k = e.getKey();
                return this.map.containsKey(k) && this.map.getInt(k) == e.getIntValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object value = e.getValue();
            if (value == null || !(value instanceof Integer)) {
                return false;
            }
            return this.map.containsKey(k) && this.map.getInt(k) == ((Integer)value).intValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Object2IntMap.Entry) {
                Object2IntMap.Entry e = (Object2IntMap.Entry)o;
                return this.map.remove(e.getKey(), e.getIntValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object value = e.getValue();
            if (value == null || !(value instanceof Integer)) {
                return false;
            }
            int v = (Integer)value;
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry<K>
    implements Object2IntMap.Entry<K> {
        protected K key;
        protected int value;

        public BasicEntry() {
        }

        public BasicEntry(K key, Integer value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(K key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public int getIntValue() {
            return this.value;
        }

        @Override
        public int setValue(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Object2IntMap.Entry) {
                Object2IntMap.Entry e = (Object2IntMap.Entry)o;
                return Objects.equals(this.key, e.getKey()) && this.value == e.getIntValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value = e.getValue();
            if (value == null || !(value instanceof Integer)) {
                return false;
            }
            return Objects.equals(this.key, key) && this.value == (Integer)value;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

