/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.io.airlift.compress.gzip;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import org.apache.iceberg.shaded.io.airlift.compress.hadoop.HadoopInputStream;

class JdkGzipHadoopInputStream
extends HadoopInputStream {
    private final byte[] oneByte = new byte[1];
    private final GZIPInputStream input;

    public JdkGzipHadoopInputStream(InputStream input, int bufferSize) throws IOException {
        this.input = new GZIPInputStream((InputStream)new GzipBufferedInputStream(input, bufferSize), bufferSize);
    }

    @Override
    public int read() throws IOException {
        int length = this.input.read(this.oneByte, 0, 1);
        if (length < 0) {
            return length;
        }
        return this.oneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] output, int offset, int length) throws IOException {
        return this.input.read(output, offset, length);
    }

    @Override
    public void resetState() {
        throw new UnsupportedOperationException("resetState not supported for gzip");
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    private static class GzipBufferedInputStream
    extends BufferedInputStream {
        public GzipBufferedInputStream(InputStream input, int bufferSize) {
            super(Objects.requireNonNull(input, "input is null"), bufferSize);
        }

        @Override
        public int available() throws IOException {
            return Math.max(1, super.available());
        }
    }
}

