/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.IOException;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.MetadataUpdateParser;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.UnboundPartitionSpec;
import org.apache.iceberg.UnboundSortOrder;
import org.apache.iceberg.UpdateRequirement;
import org.apache.iceberg.UpdateRequirementParser;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.TableIdentifierParser;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.iceberg.rest.requests.CommitTransactionRequestParser;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.CreateViewRequestParser;
import org.apache.iceberg.rest.requests.ImmutableCreateViewRequest;
import org.apache.iceberg.rest.requests.ImmutableRegisterTableRequest;
import org.apache.iceberg.rest.requests.ImmutableReportMetricsRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequestParser;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequestParser;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequestParser;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.ErrorResponseParser;
import org.apache.iceberg.rest.responses.ImmutableLoadViewResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.LoadViewResponseParser;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.iceberg.util.JsonUtil;

public class RESTSerializers {
    private RESTSerializers() {
    }

    public static void registerAll(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(ErrorResponse.class, new ErrorResponseSerializer()).addDeserializer(ErrorResponse.class, new ErrorResponseDeserializer()).addSerializer(TableIdentifier.class, new TableIdentifierSerializer()).addDeserializer(TableIdentifier.class, new TableIdentifierDeserializer()).addSerializer(Namespace.class, new NamespaceSerializer()).addDeserializer(Namespace.class, new NamespaceDeserializer()).addSerializer(Schema.class, new SchemaSerializer()).addDeserializer(Schema.class, new SchemaDeserializer()).addSerializer(UnboundPartitionSpec.class, new UnboundPartitionSpecSerializer()).addDeserializer(UnboundPartitionSpec.class, new UnboundPartitionSpecDeserializer()).addSerializer(UnboundSortOrder.class, new UnboundSortOrderSerializer()).addDeserializer(UnboundSortOrder.class, new UnboundSortOrderDeserializer()).addSerializer(MetadataUpdate.class, new MetadataUpdateSerializer()).addDeserializer(MetadataUpdate.class, new MetadataUpdateDeserializer()).addSerializer(TableMetadata.class, new TableMetadataSerializer()).addDeserializer(TableMetadata.class, new TableMetadataDeserializer()).addSerializer(UpdateRequirement.class, new UpdateReqSerializer()).addDeserializer(UpdateRequirement.class, new UpdateReqDeserializer()).addSerializer(OAuthTokenResponse.class, new OAuthTokenResponseSerializer()).addDeserializer(OAuthTokenResponse.class, new OAuthTokenResponseDeserializer()).addSerializer(ReportMetricsRequest.class, new ReportMetricsRequestSerializer()).addDeserializer(ReportMetricsRequest.class, new ReportMetricsRequestDeserializer()).addSerializer(ImmutableReportMetricsRequest.class, new ReportMetricsRequestSerializer()).addDeserializer(ImmutableReportMetricsRequest.class, new ReportMetricsRequestDeserializer()).addSerializer(CommitTransactionRequest.class, new CommitTransactionRequestSerializer()).addDeserializer(CommitTransactionRequest.class, new CommitTransactionRequestDeserializer()).addSerializer(UpdateTableRequest.class, new UpdateTableRequestSerializer()).addDeserializer(UpdateTableRequest.class, new UpdateTableRequestDeserializer()).addSerializer(RegisterTableRequest.class, new RegisterTableRequestSerializer()).addDeserializer(RegisterTableRequest.class, new RegisterTableRequestDeserializer()).addSerializer(ImmutableRegisterTableRequest.class, new RegisterTableRequestSerializer()).addDeserializer(ImmutableRegisterTableRequest.class, new RegisterTableRequestDeserializer()).addSerializer(CreateViewRequest.class, new CreateViewRequestSerializer()).addSerializer(ImmutableCreateViewRequest.class, new CreateViewRequestSerializer()).addDeserializer(CreateViewRequest.class, new CreateViewRequestDeserializer()).addDeserializer(ImmutableCreateViewRequest.class, new CreateViewRequestDeserializer()).addSerializer(LoadViewResponse.class, new LoadViewResponseSerializer()).addSerializer(ImmutableLoadViewResponse.class, new LoadViewResponseSerializer()).addDeserializer(LoadViewResponse.class, new LoadViewResponseDeserializer()).addDeserializer(ImmutableLoadViewResponse.class, new LoadViewResponseDeserializer());
        mapper.registerModule(module);
    }

    static class LoadViewResponseDeserializer<T extends LoadViewResponse>
    extends JsonDeserializer<T> {
        LoadViewResponseDeserializer() {
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)LoadViewResponseParser.fromJson(jsonNode);
        }
    }

    static class LoadViewResponseSerializer<T extends LoadViewResponse>
    extends JsonSerializer<T> {
        LoadViewResponseSerializer() {
        }

        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            LoadViewResponseParser.toJson(request, gen);
        }
    }

    static class CreateViewRequestDeserializer<T extends CreateViewRequest>
    extends JsonDeserializer<T> {
        CreateViewRequestDeserializer() {
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)CreateViewRequestParser.fromJson(jsonNode);
        }
    }

    static class CreateViewRequestSerializer<T extends CreateViewRequest>
    extends JsonSerializer<T> {
        CreateViewRequestSerializer() {
        }

        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            CreateViewRequestParser.toJson(request, gen);
        }
    }

    public static class RegisterTableRequestDeserializer<T extends RegisterTableRequest>
    extends JsonDeserializer<T> {
        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)RegisterTableRequestParser.fromJson(jsonNode);
        }
    }

    public static class RegisterTableRequestSerializer<T extends RegisterTableRequest>
    extends JsonSerializer<T> {
        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            RegisterTableRequestParser.toJson(request, gen);
        }
    }

    public static class UpdateTableRequestDeserializer
    extends JsonDeserializer<UpdateTableRequest> {
        @Override
        public UpdateTableRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return UpdateTableRequestParser.fromJson(jsonNode);
        }
    }

    public static class UpdateTableRequestSerializer
    extends JsonSerializer<UpdateTableRequest> {
        @Override
        public void serialize(UpdateTableRequest request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            UpdateTableRequestParser.toJson(request, gen);
        }
    }

    public static class CommitTransactionRequestDeserializer
    extends JsonDeserializer<CommitTransactionRequest> {
        @Override
        public CommitTransactionRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return CommitTransactionRequestParser.fromJson(jsonNode);
        }
    }

    public static class CommitTransactionRequestSerializer
    extends JsonSerializer<CommitTransactionRequest> {
        @Override
        public void serialize(CommitTransactionRequest request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            CommitTransactionRequestParser.toJson(request, gen);
        }
    }

    public static class ReportMetricsRequestDeserializer<T extends ReportMetricsRequest>
    extends JsonDeserializer<T> {
        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)ReportMetricsRequestParser.fromJson(jsonNode);
        }
    }

    public static class ReportMetricsRequestSerializer<T extends ReportMetricsRequest>
    extends JsonSerializer<T> {
        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            ReportMetricsRequestParser.toJson(request, gen);
        }
    }

    public static class OAuthTokenResponseDeserializer
    extends JsonDeserializer<OAuthTokenResponse> {
        @Override
        public OAuthTokenResponse deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return OAuth2Util.tokenResponseFromJson(jsonNode);
        }
    }

    public static class OAuthTokenResponseSerializer
    extends JsonSerializer<OAuthTokenResponse> {
        @Override
        public void serialize(OAuthTokenResponse tokenResponse, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            OAuth2Util.tokenResponseToJson(tokenResponse, gen);
        }
    }

    public static class UnboundSortOrderDeserializer
    extends JsonDeserializer<UnboundSortOrder> {
        @Override
        public UnboundSortOrder deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return SortOrderParser.fromJson(jsonNode);
        }
    }

    public static class UnboundSortOrderSerializer
    extends JsonSerializer<UnboundSortOrder> {
        @Override
        public void serialize(UnboundSortOrder sortOrder, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            SortOrderParser.toJson(sortOrder, gen);
        }
    }

    public static class UnboundPartitionSpecDeserializer
    extends JsonDeserializer<UnboundPartitionSpec> {
        @Override
        public UnboundPartitionSpec deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return PartitionSpecParser.fromJson(jsonNode);
        }
    }

    public static class UnboundPartitionSpecSerializer
    extends JsonSerializer<UnboundPartitionSpec> {
        @Override
        public void serialize(UnboundPartitionSpec spec, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            PartitionSpecParser.toJson(spec, gen);
        }
    }

    public static class SchemaSerializer
    extends JsonSerializer<Schema> {
        @Override
        public void serialize(Schema schema, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            SchemaParser.toJson(schema, gen);
        }
    }

    public static class SchemaDeserializer
    extends JsonDeserializer<Schema> {
        @Override
        public Schema deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return SchemaParser.fromJson(jsonNode);
        }
    }

    public static class TableIdentifierSerializer
    extends JsonSerializer<TableIdentifier> {
        @Override
        public void serialize(TableIdentifier identifier, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            TableIdentifierParser.toJson(identifier, gen);
        }
    }

    public static class TableIdentifierDeserializer
    extends JsonDeserializer<TableIdentifier> {
        @Override
        public TableIdentifier deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return TableIdentifierParser.fromJson(jsonNode);
        }
    }

    public static class NamespaceSerializer
    extends JsonSerializer<Namespace> {
        @Override
        public void serialize(Namespace namespace, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String[] parts = namespace.levels();
            gen.writeArray(parts, 0, parts.length);
        }
    }

    public static class NamespaceDeserializer
    extends JsonDeserializer<Namespace> {
        @Override
        public Namespace deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String[] levels = JsonUtil.getStringArray((JsonNode)p.getCodec().readTree(p));
            return Namespace.of(levels);
        }
    }

    public static class ErrorResponseSerializer
    extends JsonSerializer<ErrorResponse> {
        @Override
        public void serialize(ErrorResponse errorResponse, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            ErrorResponseParser.toJson(errorResponse, gen);
        }
    }

    public static class ErrorResponseDeserializer
    extends JsonDeserializer<ErrorResponse> {
        @Override
        public ErrorResponse deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return ErrorResponseParser.fromJson(node);
        }
    }

    public static class MetadataUpdateSerializer
    extends JsonSerializer<MetadataUpdate> {
        @Override
        public void serialize(MetadataUpdate value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            MetadataUpdateParser.toJson(value, gen);
        }
    }

    public static class MetadataUpdateDeserializer
    extends JsonDeserializer<MetadataUpdate> {
        @Override
        public MetadataUpdate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return MetadataUpdateParser.fromJson(node);
        }
    }

    public static class TableMetadataSerializer
    extends JsonSerializer<TableMetadata> {
        @Override
        public void serialize(TableMetadata metadata, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            TableMetadataParser.toJson(metadata, gen);
        }
    }

    public static class TableMetadataDeserializer
    extends JsonDeserializer<TableMetadata> {
        @Override
        public TableMetadata deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return TableMetadataParser.fromJson(node);
        }
    }

    static class UpdateReqSerializer
    extends JsonSerializer<UpdateRequirement> {
        UpdateReqSerializer() {
        }

        @Override
        public void serialize(UpdateRequirement value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            UpdateRequirementParser.toJson(value, gen);
        }
    }

    static class UpdateReqDeserializer
    extends JsonDeserializer<UpdateRequirement> {
        UpdateReqDeserializer() {
        }

        @Override
        public UpdateRequirement deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return UpdateRequirementParser.fromJson(node);
        }
    }
}

