/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.gcs;

import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.gcp.GCPProperties;
import org.apache.iceberg.gcp.gcs.GCSInputFile;
import org.apache.iceberg.gcp.gcs.GCSLocation;
import org.apache.iceberg.gcp.gcs.GCSOutputFile;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.DelegateFileIO;
import org.apache.iceberg.io.FileInfo;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.util.SerializableMap;
import org.apache.iceberg.util.SerializableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCSFileIO
implements DelegateFileIO {
    private static final Logger LOG = LoggerFactory.getLogger(GCSFileIO.class);
    private static final String DEFAULT_METRICS_IMPL = "org.apache.iceberg.hadoop.HadoopMetricsContext";
    private SerializableSupplier<Storage> storageSupplier;
    private GCPProperties gcpProperties;
    private volatile transient Storage storage;
    private MetricsContext metrics = MetricsContext.nullMetrics();
    private final AtomicBoolean isResourceClosed = new AtomicBoolean(false);
    private SerializableMap<String, String> properties = null;

    public GCSFileIO() {
    }

    public GCSFileIO(SerializableSupplier<Storage> storageSupplier, GCPProperties gcpProperties) {
        this.storageSupplier = storageSupplier;
        this.gcpProperties = gcpProperties;
    }

    @Override
    public InputFile newInputFile(String path) {
        return GCSInputFile.fromLocation(path, this.client(), this.gcpProperties, this.metrics);
    }

    @Override
    public InputFile newInputFile(String path, long length) {
        return GCSInputFile.fromLocation(path, length, this.client(), this.gcpProperties, this.metrics);
    }

    @Override
    public OutputFile newOutputFile(String path) {
        return GCSOutputFile.fromLocation(path, this.client(), this.gcpProperties, this.metrics);
    }

    @Override
    public void deleteFile(String path) {
        if (!this.client().delete(BlobId.fromGsUtilUri((String)path))) {
            LOG.warn("Failed to delete path: {}", (Object)path);
        }
    }

    @Override
    public Map<String, String> properties() {
        return this.properties.immutableMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Storage client() {
        if (this.storage == null) {
            GCSFileIO gCSFileIO = this;
            synchronized (gCSFileIO) {
                if (this.storage == null) {
                    this.storage = (Storage)this.storageSupplier.get();
                }
            }
        }
        return this.storage;
    }

    @Override
    public void initialize(Map<String, String> props) {
        this.properties = SerializableMap.copyOf(props);
        this.gcpProperties = new GCPProperties(this.properties);
        this.storageSupplier = () -> {
            StorageOptions.Builder builder = StorageOptions.newBuilder();
            this.gcpProperties.projectId().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setProjectId(arg_0));
            this.gcpProperties.clientLibToken().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setClientLibToken(arg_0));
            this.gcpProperties.serviceHost().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setHost(arg_0));
            if (this.gcpProperties.noAuth()) {
                builder.setCredentials((Credentials)NoCredentials.getInstance());
            }
            this.gcpProperties.oauth2Token().ifPresent(token -> {
                AccessToken accessToken = new AccessToken(token, (Date)this.gcpProperties.oauth2TokenExpiresAt().orElse(null));
                builder.setCredentials((Credentials)OAuth2Credentials.create((AccessToken)accessToken));
            });
            return (Storage)builder.build().getService();
        };
        this.initMetrics(this.properties);
    }

    private void initMetrics(Map<String, String> props) {
        try {
            DynConstructors.Ctor ctor = DynConstructors.builder(MetricsContext.class).hiddenImpl(DEFAULT_METRICS_IMPL, String.class).buildChecked();
            MetricsContext context = (MetricsContext)ctor.newInstance("gcs");
            context.initialize(props);
            this.metrics = context;
        }
        catch (ClassCastException | NoClassDefFoundError | NoSuchMethodException e) {
            LOG.warn("Unable to load metrics class: '{}', falling back to null metrics", (Object)DEFAULT_METRICS_IMPL);
        }
    }

    @Override
    public void close() {
        if (this.isResourceClosed.compareAndSet(false, true) && this.storage != null) {
            this.storage = null;
        }
    }

    @Override
    public Iterable<FileInfo> listPrefix(String prefix) {
        GCSLocation location = new GCSLocation(prefix);
        return () -> this.client().list(location.bucket(), new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)location.prefix())}).streamAll().map(blob -> new FileInfo(String.format("gs://%s/%s", blob.getBucket(), blob.getName()), blob.getSize(), this.createTimeMillis((Blob)blob))).iterator();
    }

    private long createTimeMillis(Blob blob) {
        if (blob.getCreateTimeOffsetDateTime() == null) {
            return 0L;
        }
        return blob.getCreateTimeOffsetDateTime().toInstant().toEpochMilli();
    }

    @Override
    public void deletePrefix(String prefix) {
        this.internalDeleteFiles(Streams.stream(this.listPrefix(prefix)).map(fileInfo -> BlobId.fromGsUtilUri((String)fileInfo.location())));
    }

    @Override
    public void deleteFiles(Iterable<String> pathsToDelete) throws BulkDeletionFailureException {
        this.internalDeleteFiles(Streams.stream(pathsToDelete).map(BlobId::fromGsUtilUri));
    }

    private void internalDeleteFiles(Stream<BlobId> blobIdsToDelete) {
        Streams.stream(Iterators.partition(blobIdsToDelete.iterator(), this.gcpProperties.deleteBatchSize())).forEach(batch -> this.client().delete((Iterable)batch));
    }
}

