/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.List;
import java.util.function.Supplier;
import org.apache.iceberg.avro.AvroCustomOrderSchemaVisitor;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.shaded.org.apache.avro.Schema;

class MissingIds
extends AvroCustomOrderSchemaVisitor<Boolean, Boolean> {
    MissingIds() {
    }

    @Override
    public Boolean record(Schema record, List<String> names, Iterable<Boolean> fields) {
        return Iterables.any(fields, Boolean.TRUE::equals);
    }

    @Override
    public Boolean field(Schema.Field field, Supplier<Boolean> fieldResult) {
        return !AvroSchemaUtil.hasFieldId(field) || fieldResult.get() != false;
    }

    @Override
    public Boolean map(Schema map, Supplier<Boolean> value) {
        return !AvroSchemaUtil.hasProperty(map, "key-id") || !AvroSchemaUtil.hasProperty(map, "value-id") || value.get() != false;
    }

    @Override
    public Boolean array(Schema array, Supplier<Boolean> element) {
        return !AvroSchemaUtil.hasProperty(array, "element-id") || element.get() != false;
    }

    @Override
    public Boolean union(Schema union, Iterable<Boolean> options) {
        return Iterables.any(options, Boolean.TRUE::equals);
    }

    @Override
    public Boolean primitive(Schema primitive) {
        return false;
    }
}

