/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseReadOnlyTable;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionStatisticsFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.transforms.Transforms;

public abstract class BaseMetadataTable
extends BaseReadOnlyTable
implements Serializable {
    private final PartitionSpec spec = PartitionSpec.unpartitioned();
    private final SortOrder sortOrder = SortOrder.unsorted();
    private final BaseTable table;
    private final String name;
    private final UUID uuid;

    protected BaseMetadataTable(Table table, String name) {
        super("metadata");
        Preconditions.checkArgument(table instanceof BaseTable, "Cannot create metadata table for non-data table: %s", (Object)table);
        this.table = (BaseTable)table;
        this.name = name;
        this.uuid = UUID.randomUUID();
    }

    static PartitionSpec transformSpec(Schema metadataTableSchema, PartitionSpec spec) {
        PartitionSpec.Builder builder = PartitionSpec.builderFor(metadataTableSchema).withSpecId(spec.specId()).checkConflicts(false);
        for (PartitionField field : spec.fields()) {
            builder.add(field.fieldId(), field.fieldId(), field.name(), Transforms.identity());
        }
        return builder.build();
    }

    static Map<Integer, PartitionSpec> transformSpecs(Schema metadataTableSchema, Map<Integer, PartitionSpec> specs) {
        return specs.values().stream().map(spec -> BaseMetadataTable.transformSpec(metadataTableSchema, spec)).collect(Collectors.toMap(PartitionSpec::specId, spec -> spec));
    }

    abstract MetadataTableType metadataTableType();

    public BaseTable table() {
        return this.table;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public FileIO io() {
        return this.table().io();
    }

    @Override
    public String location() {
        return this.table().location();
    }

    @Override
    public EncryptionManager encryption() {
        return this.table().encryption();
    }

    @Override
    public LocationProvider locationProvider() {
        return this.table().locationProvider();
    }

    @Override
    public void refresh() {
        this.table().refresh();
    }

    @Override
    public Map<Integer, Schema> schemas() {
        return ImmutableMap.of(0, this.schema());
    }

    @Override
    public PartitionSpec spec() {
        return this.spec;
    }

    @Override
    public Map<Integer, PartitionSpec> specs() {
        return ImmutableMap.of(this.spec.specId(), this.spec);
    }

    @Override
    public SortOrder sortOrder() {
        return this.sortOrder;
    }

    @Override
    public Map<Integer, SortOrder> sortOrders() {
        return ImmutableMap.of(this.sortOrder.orderId(), this.sortOrder);
    }

    @Override
    public Map<String, String> properties() {
        return ImmutableMap.of();
    }

    @Override
    public Snapshot currentSnapshot() {
        return this.table().currentSnapshot();
    }

    @Override
    public Iterable<Snapshot> snapshots() {
        return this.table().snapshots();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.table().snapshot(snapshotId);
    }

    @Override
    public List<HistoryEntry> history() {
        return this.table().history();
    }

    @Override
    public List<StatisticsFile> statisticsFiles() {
        return ImmutableList.of();
    }

    @Override
    public List<PartitionStatisticsFile> partitionStatisticsFiles() {
        return ImmutableList.of();
    }

    @Override
    public Map<String, SnapshotRef> refs() {
        return this.table().refs();
    }

    @Override
    public UUID uuid() {
        return this.uuid;
    }

    public String toString() {
        return this.name();
    }

    final Object writeReplace() {
        return SerializableTable.copyOf(this);
    }
}

