/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.CharSequenceWrapper;

public class CharSequenceMap<V>
implements Map<CharSequence, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<CharSequenceWrapper> WRAPPERS = ThreadLocal.withInitial(() -> CharSequenceWrapper.wrap(null));
    private final Map<CharSequenceWrapper, V> wrapperMap = Maps.newHashMap();

    private CharSequenceMap() {
    }

    public static <T> CharSequenceMap<T> create() {
        return new CharSequenceMap();
    }

    @Override
    public int size() {
        return this.wrapperMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapperMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof CharSequence) {
            CharSequenceWrapper wrapper = WRAPPERS.get();
            boolean result = this.wrapperMap.containsKey(wrapper.set((CharSequence)key));
            wrapper.set(null);
            return result;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapperMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (key instanceof CharSequence) {
            CharSequenceWrapper wrapper = WRAPPERS.get();
            V result = this.wrapperMap.get(wrapper.set((CharSequence)key));
            wrapper.set(null);
            return result;
        }
        return null;
    }

    @Override
    public V put(CharSequence key, V value) {
        return this.wrapperMap.put(CharSequenceWrapper.wrap(key), value);
    }

    @Override
    public V remove(Object key) {
        if (key instanceof CharSequence) {
            CharSequenceWrapper wrapper = WRAPPERS.get();
            V result = this.wrapperMap.remove(wrapper.set((CharSequence)key));
            wrapper.set(null);
            return result;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends CharSequence, ? extends V> otherMap) {
        otherMap.forEach(this::put);
    }

    @Override
    public void clear() {
        this.wrapperMap.clear();
    }

    @Override
    public Set<CharSequence> keySet() {
        CharSequenceSet keySet = CharSequenceSet.empty();
        for (CharSequenceWrapper wrapper : this.wrapperMap.keySet()) {
            keySet.add(wrapper.get());
        }
        return keySet;
    }

    @Override
    public Collection<V> values() {
        return this.wrapperMap.values();
    }

    @Override
    public Set<Map.Entry<CharSequence, V>> entrySet() {
        HashSet<Map.Entry<CharSequence, V>> entrySet = Sets.newHashSet();
        for (Map.Entry<CharSequenceWrapper, V> entry : this.wrapperMap.entrySet()) {
            entrySet.add(new CharSequenceEntry(entry));
        }
        return entrySet;
    }

    public V computeIfAbsent(CharSequence key, Supplier<V> valueSupplier) {
        return (V)this.computeIfAbsent(key, (? super K ignored) -> valueSupplier.get());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CharSequenceMap that = (CharSequenceMap)other;
        return Objects.equals(this.wrapperMap, that.wrapperMap);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.wrapperMap);
    }

    public String toString() {
        return this.entrySet().stream().map(this::toString).collect(Collectors.joining(", ", "{", "}"));
    }

    private String toString(Map.Entry<CharSequence, V> entry) {
        CharSequence key = entry.getKey();
        V value = entry.getValue();
        return key + "=" + (value == this ? "(this Map)" : value);
    }

    private static class CharSequenceEntry<V>
    implements Map.Entry<CharSequence, V> {
        private final Map.Entry<CharSequenceWrapper, V> inner;

        private CharSequenceEntry(Map.Entry<CharSequenceWrapper, V> inner) {
            this.inner = inner;
        }

        @Override
        public CharSequence getKey() {
            return this.inner.getKey().get();
        }

        @Override
        public V getValue() {
            return this.inner.getValue();
        }

        @Override
        public int hashCode() {
            return this.inner.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CharSequenceEntry that = (CharSequenceEntry)other;
            return this.inner.equals(that.inner);
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("Cannot set value");
        }
    }
}

