/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.DataFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.BoundAggregate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.Expression;

public class CountAggregate<T>
extends BoundAggregate<T, Long> {
    protected CountAggregate(Expression.Operation op, BoundTerm<T> term) {
        super(op, term);
    }

    @Override
    public Long eval(StructLike struct) {
        return this.countFor(struct);
    }

    @Override
    public Long eval(DataFile file) {
        return this.countFor(file);
    }

    protected Long countFor(StructLike row) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement countFor(StructLike)");
    }

    protected Long countFor(DataFile file) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement countFor(DataFile)");
    }

    @Override
    public BoundAggregate.Aggregator<Long> newAggregator() {
        return new CountAggregator(this);
    }

    private static class CountAggregator<T>
    extends BoundAggregate.NullSafeAggregator<T, Long> {
        private Long count = 0L;

        CountAggregator(BoundAggregate<T, Long> aggregate) {
            super(aggregate);
        }

        @Override
        protected void update(Long value) {
            this.count = this.count + value;
        }

        @Override
        protected Long current() {
            return this.count;
        }
    }
}

