/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.function.Supplier;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.CharSequenceUtil;

public class FileScopedPositionDeleteWriter<T>
implements FileWriter<PositionDelete<T>, DeleteWriteResult> {
    private final Supplier<FileWriter<PositionDelete<T>, DeleteWriteResult>> writers;
    private final List<DeleteFile> deleteFiles;
    private final CharSequenceSet referencedDataFiles;
    private FileWriter<PositionDelete<T>, DeleteWriteResult> currentWriter = null;
    private CharSequence currentPath = null;
    private boolean closed = false;

    public FileScopedPositionDeleteWriter(Supplier<FileWriter<PositionDelete<T>, DeleteWriteResult>> writers) {
        this.writers = writers;
        this.deleteFiles = Lists.newArrayList();
        this.referencedDataFiles = CharSequenceSet.empty();
    }

    @Override
    public void write(PositionDelete<T> positionDelete) {
        this.writer(positionDelete.path()).write(positionDelete);
    }

    private FileWriter<PositionDelete<T>, DeleteWriteResult> writer(CharSequence path) {
        if (this.currentWriter == null) {
            this.openCurrentWriter(path);
        } else if (CharSequenceUtil.unequalPaths(this.currentPath, path)) {
            this.closeCurrentWriter();
            this.openCurrentWriter(path);
        }
        return this.currentWriter;
    }

    @Override
    public long length() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement length");
    }

    @Override
    public DeleteWriteResult result() {
        Preconditions.checkState(this.closed, "Cannot get result from unclosed writer");
        return new DeleteWriteResult(this.deleteFiles, this.referencedDataFiles);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closeCurrentWriter();
            this.closed = true;
        }
    }

    private void openCurrentWriter(CharSequence path) {
        Preconditions.checkState(!this.closed, "Writer has already been closed");
        this.currentWriter = this.writers.get();
        this.currentPath = path;
    }

    private void closeCurrentWriter() {
        if (this.currentWriter != null) {
            try {
                this.currentWriter.close();
                DeleteWriteResult result = this.currentWriter.result();
                this.deleteFiles.addAll(result.deleteFiles());
                this.referencedDataFiles.addAll(result.referencedDataFiles());
                this.currentWriter = null;
                this.currentPath = null;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close current writer", e);
            }
        }
    }
}

