/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.immutables.value.Generated;
import org.projectnessie.model.GarbageCollectorConfig;
import org.projectnessie.model.Util;

@ParametersAreNonnullByDefault
@Generated(from="GarbageCollectorConfig", generator="Immutables")
@Immutable
public final class ImmutableGarbageCollectorConfig
implements GarbageCollectorConfig {
    @Nullable
    private final String defaultCutoffPolicy;
    private final List<GarbageCollectorConfig.ReferenceCutoffPolicy> perRefCutoffPolicies;
    @Nullable
    private final Duration newFilesGracePeriod;
    @Nullable
    private final Integer expectedFileCountPerContent;

    private ImmutableGarbageCollectorConfig(@Nullable String defaultCutoffPolicy, List<GarbageCollectorConfig.ReferenceCutoffPolicy> perRefCutoffPolicies, @Nullable Duration newFilesGracePeriod, @Nullable Integer expectedFileCountPerContent) {
        this.defaultCutoffPolicy = defaultCutoffPolicy;
        this.perRefCutoffPolicies = perRefCutoffPolicies;
        this.newFilesGracePeriod = newFilesGracePeriod;
        this.expectedFileCountPerContent = expectedFileCountPerContent;
    }

    @Override
    @JsonProperty(value="defaultCutoffPolicy")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String getDefaultCutoffPolicy() {
        return this.defaultCutoffPolicy;
    }

    @Override
    @JsonProperty(value="perRefCutoffPolicies")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<GarbageCollectorConfig.ReferenceCutoffPolicy> getPerRefCutoffPolicies() {
        return this.perRefCutoffPolicies;
    }

    @Override
    @JsonProperty(value="newFilesGracePeriod")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=Util.DurationSerializer.class)
    @JsonDeserialize(using=Util.DurationDeserializer.class)
    @Nullable
    public Duration getNewFilesGracePeriod() {
        return this.newFilesGracePeriod;
    }

    @Override
    @JsonProperty(value="expectedFileCountPerContent")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Integer getExpectedFileCountPerContent() {
        return this.expectedFileCountPerContent;
    }

    public final ImmutableGarbageCollectorConfig withDefaultCutoffPolicy(@Nullable String value) {
        if (Objects.equals(this.defaultCutoffPolicy, value)) {
            return this;
        }
        return ImmutableGarbageCollectorConfig.validate(new ImmutableGarbageCollectorConfig(value, this.perRefCutoffPolicies, this.newFilesGracePeriod, this.expectedFileCountPerContent));
    }

    public final ImmutableGarbageCollectorConfig withPerRefCutoffPolicies(GarbageCollectorConfig.ReferenceCutoffPolicy ... elements) {
        List<GarbageCollectorConfig.ReferenceCutoffPolicy> newValue = ImmutableGarbageCollectorConfig.createUnmodifiableList(false, ImmutableGarbageCollectorConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableGarbageCollectorConfig.validate(new ImmutableGarbageCollectorConfig(this.defaultCutoffPolicy, newValue, this.newFilesGracePeriod, this.expectedFileCountPerContent));
    }

    public final ImmutableGarbageCollectorConfig withPerRefCutoffPolicies(Iterable<? extends GarbageCollectorConfig.ReferenceCutoffPolicy> elements) {
        if (this.perRefCutoffPolicies == elements) {
            return this;
        }
        List<GarbageCollectorConfig.ReferenceCutoffPolicy> newValue = ImmutableGarbageCollectorConfig.createUnmodifiableList(false, ImmutableGarbageCollectorConfig.createSafeList(elements, true, false));
        return ImmutableGarbageCollectorConfig.validate(new ImmutableGarbageCollectorConfig(this.defaultCutoffPolicy, newValue, this.newFilesGracePeriod, this.expectedFileCountPerContent));
    }

    public final ImmutableGarbageCollectorConfig withNewFilesGracePeriod(@Nullable Duration value) {
        if (this.newFilesGracePeriod == value) {
            return this;
        }
        return ImmutableGarbageCollectorConfig.validate(new ImmutableGarbageCollectorConfig(this.defaultCutoffPolicy, this.perRefCutoffPolicies, value, this.expectedFileCountPerContent));
    }

    public final ImmutableGarbageCollectorConfig withExpectedFileCountPerContent(@Nullable Integer value) {
        if (Objects.equals(this.expectedFileCountPerContent, value)) {
            return this;
        }
        return ImmutableGarbageCollectorConfig.validate(new ImmutableGarbageCollectorConfig(this.defaultCutoffPolicy, this.perRefCutoffPolicies, this.newFilesGracePeriod, value));
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGarbageCollectorConfig && this.equalTo(0, (ImmutableGarbageCollectorConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableGarbageCollectorConfig another) {
        return Objects.equals(this.defaultCutoffPolicy, another.defaultCutoffPolicy) && this.perRefCutoffPolicies.equals(another.perRefCutoffPolicies) && Objects.equals(this.newFilesGracePeriod, another.newFilesGracePeriod) && Objects.equals(this.expectedFileCountPerContent, another.expectedFileCountPerContent);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.defaultCutoffPolicy);
        h2 += (h2 << 5) + this.perRefCutoffPolicies.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.newFilesGracePeriod);
        h2 += (h2 << 5) + Objects.hashCode(this.expectedFileCountPerContent);
        return h2;
    }

    public String toString() {
        return "GarbageCollectorConfig{defaultCutoffPolicy=" + this.defaultCutoffPolicy + ", perRefCutoffPolicies=" + this.perRefCutoffPolicies + ", newFilesGracePeriod=" + this.newFilesGracePeriod + ", expectedFileCountPerContent=" + this.expectedFileCountPerContent + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGarbageCollectorConfig fromJson(Json json) {
        Builder builder = ImmutableGarbageCollectorConfig.builder();
        if (json.defaultCutoffPolicy != null) {
            builder.defaultCutoffPolicy(json.defaultCutoffPolicy);
        }
        if (json.perRefCutoffPolicies != null) {
            builder.addAllPerRefCutoffPolicies(json.perRefCutoffPolicies);
        }
        if (json.newFilesGracePeriod != null) {
            builder.newFilesGracePeriod(json.newFilesGracePeriod);
        }
        if (json.expectedFileCountPerContent != null) {
            builder.expectedFileCountPerContent(json.expectedFileCountPerContent);
        }
        return builder.build();
    }

    private static ImmutableGarbageCollectorConfig validate(ImmutableGarbageCollectorConfig instance) {
        instance.checkDefaultPolicy();
        return instance;
    }

    public static ImmutableGarbageCollectorConfig copyOf(GarbageCollectorConfig instance) {
        if (instance instanceof ImmutableGarbageCollectorConfig) {
            return (ImmutableGarbageCollectorConfig)instance;
        }
        return ImmutableGarbageCollectorConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static /* synthetic */ List access$100(boolean x0, List x1) {
        return ImmutableGarbageCollectorConfig.createUnmodifiableList(x0, x1);
    }

    static /* synthetic */ ImmutableGarbageCollectorConfig access$300(ImmutableGarbageCollectorConfig x0) {
        return ImmutableGarbageCollectorConfig.validate(x0);
    }

    @Generated(from="GarbageCollectorConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @javax.annotation.Nullable
        private String defaultCutoffPolicy;
        private List<GarbageCollectorConfig.ReferenceCutoffPolicy> perRefCutoffPolicies = new ArrayList<GarbageCollectorConfig.ReferenceCutoffPolicy>();
        @javax.annotation.Nullable
        private Duration newFilesGracePeriod;
        @javax.annotation.Nullable
        private Integer expectedFileCountPerContent;

        private Builder() {
        }

        public final Builder from(GarbageCollectorConfig instance) {
            Integer expectedFileCountPerContentValue;
            Objects.requireNonNull(instance, "instance");
            String defaultCutoffPolicyValue = instance.getDefaultCutoffPolicy();
            if (defaultCutoffPolicyValue != null) {
                this.defaultCutoffPolicy(defaultCutoffPolicyValue);
            }
            this.addAllPerRefCutoffPolicies(instance.getPerRefCutoffPolicies());
            Duration newFilesGracePeriodValue = instance.getNewFilesGracePeriod();
            if (newFilesGracePeriodValue != null) {
                this.newFilesGracePeriod(newFilesGracePeriodValue);
            }
            if ((expectedFileCountPerContentValue = instance.getExpectedFileCountPerContent()) != null) {
                this.expectedFileCountPerContent(expectedFileCountPerContentValue);
            }
            return this;
        }

        @JsonProperty(value="defaultCutoffPolicy")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Builder defaultCutoffPolicy(String defaultCutoffPolicy) {
            this.defaultCutoffPolicy = defaultCutoffPolicy;
            return this;
        }

        public final Builder addPerRefCutoffPolicies(GarbageCollectorConfig.ReferenceCutoffPolicy element) {
            this.perRefCutoffPolicies.add(Objects.requireNonNull(element, "perRefCutoffPolicies element"));
            return this;
        }

        public final Builder addPerRefCutoffPolicies(GarbageCollectorConfig.ReferenceCutoffPolicy ... elements) {
            for (GarbageCollectorConfig.ReferenceCutoffPolicy element : elements) {
                this.perRefCutoffPolicies.add(Objects.requireNonNull(element, "perRefCutoffPolicies element"));
            }
            return this;
        }

        @JsonProperty(value="perRefCutoffPolicies")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public final Builder perRefCutoffPolicies(Iterable<? extends GarbageCollectorConfig.ReferenceCutoffPolicy> elements) {
            this.perRefCutoffPolicies.clear();
            return this.addAllPerRefCutoffPolicies(elements);
        }

        public final Builder addAllPerRefCutoffPolicies(Iterable<? extends GarbageCollectorConfig.ReferenceCutoffPolicy> elements) {
            for (GarbageCollectorConfig.ReferenceCutoffPolicy referenceCutoffPolicy : elements) {
                this.perRefCutoffPolicies.add(Objects.requireNonNull(referenceCutoffPolicy, "perRefCutoffPolicies element"));
            }
            return this;
        }

        @JsonProperty(value="newFilesGracePeriod")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonSerialize(using=Util.DurationSerializer.class)
        @JsonDeserialize(using=Util.DurationDeserializer.class)
        public final Builder newFilesGracePeriod(Duration newFilesGracePeriod) {
            this.newFilesGracePeriod = newFilesGracePeriod;
            return this;
        }

        @JsonProperty(value="expectedFileCountPerContent")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Builder expectedFileCountPerContent(Integer expectedFileCountPerContent) {
            this.expectedFileCountPerContent = expectedFileCountPerContent;
            return this;
        }

        public ImmutableGarbageCollectorConfig build() {
            return ImmutableGarbageCollectorConfig.validate(new ImmutableGarbageCollectorConfig(this.defaultCutoffPolicy, ImmutableGarbageCollectorConfig.createUnmodifiableList(true, this.perRefCutoffPolicies), this.newFilesGracePeriod, this.expectedFileCountPerContent));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GarbageCollectorConfig", generator="Immutables")
    static final class Json
    implements GarbageCollectorConfig {
        @javax.annotation.Nullable
        String defaultCutoffPolicy;
        @javax.annotation.Nullable
        List<GarbageCollectorConfig.ReferenceCutoffPolicy> perRefCutoffPolicies = Collections.emptyList();
        @javax.annotation.Nullable
        Duration newFilesGracePeriod;
        @javax.annotation.Nullable
        Integer expectedFileCountPerContent;

        Json() {
        }

        @JsonProperty(value="defaultCutoffPolicy")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setDefaultCutoffPolicy(String defaultCutoffPolicy) {
            this.defaultCutoffPolicy = defaultCutoffPolicy;
        }

        @JsonProperty(value="perRefCutoffPolicies")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setPerRefCutoffPolicies(List<GarbageCollectorConfig.ReferenceCutoffPolicy> perRefCutoffPolicies) {
            this.perRefCutoffPolicies = perRefCutoffPolicies;
        }

        @JsonProperty(value="newFilesGracePeriod")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonSerialize(using=Util.DurationSerializer.class)
        @JsonDeserialize(using=Util.DurationDeserializer.class)
        public void setNewFilesGracePeriod(Duration newFilesGracePeriod) {
            this.newFilesGracePeriod = newFilesGracePeriod;
        }

        @JsonProperty(value="expectedFileCountPerContent")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setExpectedFileCountPerContent(Integer expectedFileCountPerContent) {
            this.expectedFileCountPerContent = expectedFileCountPerContent;
        }

        @Override
        public String getDefaultCutoffPolicy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<GarbageCollectorConfig.ReferenceCutoffPolicy> getPerRefCutoffPolicies() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Duration getNewFilesGracePeriod() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getExpectedFileCountPerContent() {
            throw new UnsupportedOperationException();
        }
    }
}

