/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpResponse;
import org.projectnessie.client.http.HttpResponseFactory;
import org.projectnessie.client.http.OpentelemetryTracing;
import org.projectnessie.client.http.RequestFilter;
import org.projectnessie.client.http.ResponseFilter;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;
import org.projectnessie.client.http.impl.HttpUtils;
import org.projectnessie.client.http.impl.ImmutableHttpRuntimeConfig;
import org.projectnessie.client.http.impl.jdk11.JavaHttpClient;
import org.projectnessie.client.http.impl.jdk8.UrlConnectionClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpClientBuilderImpl
implements HttpClient.Builder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientBuilderImpl.class);
    private URI baseUri;
    private ObjectMapper mapper;
    private Class<?> jsonView;
    private HttpResponseFactory responseFactory = HttpResponse::new;
    private SSLContext sslContext;
    private SSLParameters sslParameters;
    private HttpAuthentication authentication;
    private int readTimeoutMillis = Integer.getInteger("sun.net.client.defaultReadTimeout", 25000);
    private int connectionTimeoutMillis = Integer.getInteger("sun.net.client.defaultConnectionTimeout", 5000);
    private boolean disableCompression;
    private final List<RequestFilter> requestFilters = new ArrayList<RequestFilter>();
    private final List<ResponseFilter> responseFilters = new ArrayList<ResponseFilter>();
    private boolean http2Upgrade;
    private String followRedirects;
    private boolean forceUrlConnectionClient;
    private int clientSpec = 2;

    HttpClientBuilderImpl() {
    }

    HttpClientBuilderImpl(HttpClientBuilderImpl other) {
        this.baseUri = other.baseUri;
        this.mapper = other.mapper;
        this.jsonView = other.jsonView;
        this.responseFactory = other.responseFactory;
        this.sslContext = other.sslContext;
        this.sslParameters = other.sslParameters;
        this.authentication = other.authentication;
        this.readTimeoutMillis = other.readTimeoutMillis;
        this.connectionTimeoutMillis = other.connectionTimeoutMillis;
        this.disableCompression = other.disableCompression;
        this.requestFilters.addAll(other.requestFilters);
        this.responseFilters.addAll(other.responseFilters);
        this.http2Upgrade = other.http2Upgrade;
        this.followRedirects = other.followRedirects;
        this.forceUrlConnectionClient = other.forceUrlConnectionClient;
        this.clientSpec = other.clientSpec;
    }

    @Override
    public HttpClient.Builder copy() {
        return new HttpClientBuilderImpl(this);
    }

    @Override
    @CanIgnoreReturnValue
    public HttpClient.Builder setClientSpec(int clientSpec) {
        this.clientSpec = clientSpec;
        return this;
    }

    @Override
    public HttpClient.Builder setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
        return this;
    }

    @Override
    public HttpClient.Builder setDisableCompression(boolean disableCompression) {
        this.disableCompression = disableCompression;
        return this;
    }

    @Override
    public HttpClient.Builder setObjectMapper(ObjectMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    @Override
    public HttpClient.Builder setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
        return this;
    }

    @Override
    public HttpClient.Builder setResponseFactory(HttpResponseFactory responseFactory) {
        this.responseFactory = responseFactory;
        return this;
    }

    @Override
    public HttpClient.Builder setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    @Override
    public HttpClient.Builder setSslParameters(SSLParameters sslParameters) {
        this.sslParameters = sslParameters;
        return this;
    }

    @Override
    public HttpClient.Builder setAuthentication(HttpAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    @Override
    public HttpClient.Builder setHttp2Upgrade(boolean http2Upgrade) {
        this.http2Upgrade = http2Upgrade;
        return this;
    }

    @Override
    public HttpClient.Builder setFollowRedirects(String followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Override
    public HttpClient.Builder setForceUrlConnectionClient(boolean forceUrlConnectionClient) {
        this.forceUrlConnectionClient = forceUrlConnectionClient;
        return this;
    }

    @Override
    public HttpClient.Builder setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    @Override
    public HttpClient.Builder setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        return this;
    }

    @Override
    public HttpClient.Builder addRequestFilter(RequestFilter filter) {
        this.requestFilters.add(filter);
        return this;
    }

    @Override
    public HttpClient.Builder addResponseFilter(ResponseFilter filter) {
        this.responseFilters.add(filter);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public HttpClient.Builder clearRequestFilters() {
        this.requestFilters.clear();
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public HttpClient.Builder clearResponseFilters() {
        this.responseFilters.clear();
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public HttpClient.Builder addTracing() {
        try {
            OpentelemetryTracing.addTracing(this);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("Failed to initialize tracing, the opentracing libraries are probably missing.", (Throwable)e);
        }
        return this;
    }

    @Override
    public HttpClient build() {
        HttpUtils.checkArgument(this.baseUri != null, "Cannot construct Http client. Must have a non-null uri", new Object[0]);
        HttpUtils.checkArgument(this.mapper != null, "Cannot construct Http client. Must have a non-null object mapper", new Object[0]);
        if (this.sslContext == null) {
            try {
                this.sslContext = SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException e) {
                throw new HttpClientException("Cannot construct Http Client. Default SSL config is invalid.", e);
            }
        }
        if (this.authentication != null) {
            this.authentication.applyToHttpClient(this);
        }
        ImmutableHttpRuntimeConfig config = HttpRuntimeConfig.builder().baseUri(this.baseUri).mapper(this.mapper).jsonView(this.jsonView).responseFactory(this.responseFactory).readTimeoutMillis(this.readTimeoutMillis).connectionTimeoutMillis(this.connectionTimeoutMillis).isDisableCompression(this.disableCompression).sslContext(this.sslContext).sslParameters(this.sslParameters).addAllRequestFilters(this.requestFilters).addAllResponseFilters(this.responseFilters).isHttp11Only(!this.http2Upgrade).followRedirects(this.followRedirects).forceUrlConnectionClient(this.forceUrlConnectionClient).build();
        return ImplSwitch.FACTORY.apply(config);
    }

    static class ImplSwitch {
        static final Function<HttpRuntimeConfig, HttpClient> FACTORY;

        ImplSwitch() {
        }

        static {
            Function<HttpRuntimeConfig, HttpClient> factory;
            try {
                Class.forName("java.net.http.HttpClient");
                factory = config -> Boolean.getBoolean("nessie.client.force-url-connection-client") || config.forceUrlConnectionClient() ? new UrlConnectionClient((HttpRuntimeConfig)config) : new JavaHttpClient((HttpRuntimeConfig)config);
            }
            catch (ClassNotFoundException e) {
                factory = UrlConnectionClient::new;
            }
            FACTORY = factory;
        }
    }
}

