/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.jdbc.JdbcClientPool;
import org.apache.iceberg.jdbc.UncheckedInterruptedException;
import org.apache.iceberg.jdbc.UncheckedSQLException;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;

final class JdbcUtil {
    static final String STRICT_MODE_PROPERTY = "jdbc.strict-mode";
    static final String CATALOG_TABLE_NAME = "iceberg_tables";
    static final String CATALOG_NAME = "catalog_name";
    static final String TABLE_NAMESPACE = "table_namespace";
    static final String TABLE_NAME = "table_name";
    static final String METADATA_LOCATION = "metadata_location";
    static final String PREVIOUS_METADATA_LOCATION = "previous_metadata_location";
    static final String DO_COMMIT_SQL = "UPDATE iceberg_tables SET metadata_location = ? , previous_metadata_location = ?  WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? AND metadata_location = ?";
    static final String CREATE_CATALOG_TABLE = "CREATE TABLE iceberg_tables(catalog_name VARCHAR(255) NOT NULL,table_namespace VARCHAR(255) NOT NULL,table_name VARCHAR(255) NOT NULL,metadata_location VARCHAR(1000),previous_metadata_location VARCHAR(1000),PRIMARY KEY (catalog_name, table_namespace, table_name))";
    static final String GET_TABLE_SQL = "SELECT * FROM iceberg_tables WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? ";
    static final String LIST_TABLES_SQL = "SELECT * FROM iceberg_tables WHERE catalog_name = ? AND table_namespace = ?";
    static final String RENAME_TABLE_SQL = "UPDATE iceberg_tables SET table_namespace = ? , table_name = ?  WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? ";
    static final String DROP_TABLE_SQL = "DELETE FROM iceberg_tables WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? ";
    static final String GET_NAMESPACE_SQL = "SELECT table_namespace FROM iceberg_tables WHERE catalog_name = ? AND  ( table_namespace = ? OR table_namespace LIKE ? ESCAPE '\\'  )  LIMIT 1";
    static final String LIST_NAMESPACES_SQL = "SELECT DISTINCT table_namespace FROM iceberg_tables WHERE catalog_name = ? AND table_namespace LIKE ?";
    static final String LIST_ALL_TABLE_NAMESPACES_SQL = "SELECT DISTINCT table_namespace FROM iceberg_tables WHERE catalog_name = ?";
    static final String DO_COMMIT_CREATE_TABLE_SQL = "INSERT INTO iceberg_tables (catalog_name, table_namespace, table_name, metadata_location, previous_metadata_location)  VALUES (?,?,?,?,null)";
    static final String NAMESPACE_PROPERTIES_TABLE_NAME = "iceberg_namespace_properties";
    static final String NAMESPACE_NAME = "namespace";
    static final String NAMESPACE_PROPERTY_KEY = "property_key";
    static final String NAMESPACE_PROPERTY_VALUE = "property_value";
    static final String CREATE_NAMESPACE_PROPERTIES_TABLE = "CREATE TABLE iceberg_namespace_properties(catalog_name VARCHAR(255) NOT NULL,namespace VARCHAR(255) NOT NULL,property_key VARCHAR(255),property_value VARCHAR(1000),PRIMARY KEY (catalog_name, namespace, property_key))";
    static final String GET_NAMESPACE_PROPERTIES_SQL = "SELECT namespace FROM iceberg_namespace_properties WHERE catalog_name = ? AND  ( namespace = ? OR namespace LIKE ? ESCAPE '\\'  ) ";
    static final String INSERT_NAMESPACE_PROPERTIES_SQL = "INSERT INTO iceberg_namespace_properties (catalog_name, namespace, property_key, property_value) VALUES ";
    static final String INSERT_PROPERTIES_VALUES_BASE = "(?,?,?,?)";
    static final String GET_ALL_NAMESPACE_PROPERTIES_SQL = "SELECT *  FROM iceberg_namespace_properties WHERE catalog_name = ? AND namespace = ? ";
    static final String DELETE_NAMESPACE_PROPERTIES_SQL = "DELETE FROM iceberg_namespace_properties WHERE catalog_name = ? AND namespace = ? AND property_key IN ";
    static final String DELETE_ALL_NAMESPACE_PROPERTIES_SQL = "DELETE FROM iceberg_namespace_properties WHERE catalog_name = ? AND namespace = ?";
    static final String LIST_PROPERTY_NAMESPACES_SQL = "SELECT DISTINCT namespace FROM iceberg_namespace_properties WHERE catalog_name = ? AND namespace LIKE ?";
    static final String LIST_ALL_PROPERTY_NAMESPACES_SQL = "SELECT DISTINCT namespace FROM iceberg_namespace_properties WHERE catalog_name = ?";
    private static final Joiner JOINER_DOT = Joiner.on('.');
    private static final Splitter SPLITTER_DOT = Splitter.on('.');

    private JdbcUtil() {
    }

    public static Namespace stringToNamespace(String namespace) {
        Preconditions.checkArgument(namespace != null, "Invalid namespace %s", (Object)namespace);
        return Namespace.of(Iterables.toArray(SPLITTER_DOT.split(namespace), String.class));
    }

    public static String namespaceToString(Namespace namespace) {
        return JOINER_DOT.join(namespace.levels());
    }

    public static TableIdentifier stringToTableIdentifier(String tableNamespace, String tableName) {
        return TableIdentifier.of(JdbcUtil.stringToNamespace(tableNamespace), tableName);
    }

    public static Properties filterAndRemovePrefix(Map<String, String> properties, String prefix) {
        Properties result = new Properties();
        properties.forEach((key, value) -> {
            if (key.startsWith(prefix)) {
                result.put(key.substring(prefix.length()), value);
            }
        });
        return result;
    }

    public static String updatePropertiesStatement(int size) {
        StringBuilder sqlStatement = new StringBuilder("UPDATE iceberg_namespace_properties SET property_value = CASE");
        for (int i = 0; i < size; ++i) {
            sqlStatement.append(" WHEN property_key = ? THEN ?");
        }
        sqlStatement.append(" END WHERE catalog_name = ? AND namespace = ? AND property_key IN ");
        String values = String.join((CharSequence)",", Collections.nCopies(size, String.valueOf('?')));
        sqlStatement.append("(").append(values).append(")");
        return sqlStatement.toString();
    }

    public static String insertPropertiesStatement(int size) {
        StringBuilder sqlStatement = new StringBuilder(INSERT_NAMESPACE_PROPERTIES_SQL);
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sqlStatement.append(", ");
            }
            sqlStatement.append(INSERT_PROPERTIES_VALUES_BASE);
        }
        return sqlStatement.toString();
    }

    public static String deletePropertiesStatement(Set<String> properties) {
        StringBuilder sqlStatement = new StringBuilder(DELETE_NAMESPACE_PROPERTIES_SQL);
        String values = String.join((CharSequence)",", Collections.nCopies(properties.size(), String.valueOf('?')));
        sqlStatement.append("(").append(values).append(")");
        return sqlStatement.toString();
    }

    static boolean namespaceExists(String catalogName, JdbcClientPool connections, Namespace namespace) {
        String namespaceEquals = JdbcUtil.namespaceToString(namespace);
        String namespaceStartsWith = namespaceEquals.replace("\\", "\\\\").replace("_", "\\_").replace("%", "\\%") + ".%";
        if (JdbcUtil.exists(connections, GET_NAMESPACE_SQL, catalogName, namespaceEquals, namespaceStartsWith)) {
            return true;
        }
        return JdbcUtil.exists(connections, GET_NAMESPACE_PROPERTIES_SQL, catalogName, namespaceEquals, namespaceStartsWith);
    }

    private static boolean exists(JdbcClientPool connections, String sql, String ... args) {
        try {
            return connections.run(conn -> {
                PreparedStatement preparedStatement = conn.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    for (int pos = 0; pos < args.length; ++pos) {
                        preparedStatement.setString(pos + 1, args[pos]);
                    }
                    ResultSet rs = preparedStatement.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        if (rs.next()) {
                            Boolean bl = true;
                            return bl;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs != null) {
                            JdbcUtil.$closeResource(throwable2, rs);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (preparedStatement != null) {
                        JdbcUtil.$closeResource(throwable, preparedStatement);
                    }
                }
                return false;
            });
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e, "Failed to execute exists query: %s", sql);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedInterruptedException(e, "Interrupted in SQL query", new Object[0]);
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

