/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.error;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonUnwrapped;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.error.ImmutableGenericErrorDetails;
import org.projectnessie.error.NessieErrorDetails;

@JsonSerialize(using=GenericTypeSerializer.class)
@JsonDeserialize(using=GenericTypeDeserializer.class)
@Value.Immutable
public abstract class GenericErrorDetails
implements NessieErrorDetails {
    @Override
    @Value.Parameter(order=1)
    public abstract String getType();

    @javax.annotation.Nullable
    @Nullable
    @Schema(type=SchemaType.OBJECT)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonUnwrapped
    @Value.Parameter(order=2)
    public abstract Map<String, Object> getAttributes();

    public static GenericErrorDetails errorUnknownType(String type, Map<String, Object> attributes) {
        return ImmutableGenericErrorDetails.of(type, attributes);
    }

    static final class GenericTypeDeserializer
    extends JsonDeserializer<GenericErrorDetails> {
        GenericTypeDeserializer() {
        }

        @Override
        public GenericErrorDetails deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Map all = p.readValueAs(Map.class);
            Object type = all.remove("type");
            if (type == null) {
                type = "UNKNOWN_ERROR_DETAILS";
            }
            return GenericErrorDetails.errorUnknownType(type.toString(), all);
        }
    }

    static final class GenericTypeSerializer
    extends JsonSerializer<GenericErrorDetails> {
        GenericTypeSerializer() {
        }

        @Override
        public void serializeWithType(GenericErrorDetails value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("type", value.getType());
            for (Map.Entry<String, Object> entry : value.getAttributes().entrySet()) {
                gen.writeFieldName(entry.getKey());
                gen.writeObject(entry.getValue());
            }
            gen.writeEndObject();
        }

        @Override
        public void serialize(GenericErrorDetails value, JsonGenerator gen, SerializerProvider serializers) {
            throw new UnsupportedOperationException();
        }
    }
}

