/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.api.v2.params.DiffParams;
import org.projectnessie.model.ContentKey;

@ParametersAreNonnullByDefault
@Generated(from="org.projectnessie.api.v2.params.DiffParams", generator="Immutables")
@NotThreadSafe
public final class DiffParamsBuilder {
    private static final long INIT_BIT_FROM_REF = 1L;
    private static final long INIT_BIT_TO_REF = 2L;
    private long initBits = 3L;
    @Nullable
    private String fromRef;
    @Nullable
    private String toRef;
    @Nullable
    private Integer maxRecords;
    @Nullable
    private String pageToken;
    @Nullable
    private ContentKey minKey;
    @Nullable
    private ContentKey maxKey;
    @Nullable
    private ContentKey prefixKey;
    private List<ContentKey> requestedKeys = null;
    @Nullable
    private String filter;

    public final DiffParamsBuilder fromRef(String fromRef) {
        this.fromRef = Objects.requireNonNull(fromRef, "fromRef");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final DiffParamsBuilder toRef(String toRef) {
        this.toRef = Objects.requireNonNull(toRef, "toRef");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public final DiffParamsBuilder maxRecords(@jakarta.annotation.Nullable Integer maxRecords) {
        this.maxRecords = maxRecords;
        return this;
    }

    public final DiffParamsBuilder pageToken(@jakarta.annotation.Nullable String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    public final DiffParamsBuilder minKey(@jakarta.annotation.Nullable ContentKey minKey) {
        this.minKey = minKey;
        return this;
    }

    public final DiffParamsBuilder maxKey(@jakarta.annotation.Nullable ContentKey maxKey) {
        this.maxKey = maxKey;
        return this;
    }

    public final DiffParamsBuilder prefixKey(@jakarta.annotation.Nullable ContentKey prefixKey) {
        this.prefixKey = prefixKey;
        return this;
    }

    public final DiffParamsBuilder addRequestedKeys(ContentKey element) {
        if (this.requestedKeys == null) {
            this.requestedKeys = new ArrayList<ContentKey>();
        }
        this.requestedKeys.add(Objects.requireNonNull(element, "requestedKeys element"));
        return this;
    }

    public final DiffParamsBuilder addRequestedKeys(ContentKey ... elements) {
        if (this.requestedKeys == null) {
            this.requestedKeys = new ArrayList<ContentKey>();
        }
        for (ContentKey element : elements) {
            this.requestedKeys.add(Objects.requireNonNull(element, "requestedKeys element"));
        }
        return this;
    }

    public final DiffParamsBuilder requestedKeys(@jakarta.annotation.Nullable Iterable<? extends ContentKey> elements) {
        if (elements == null) {
            this.requestedKeys = null;
            return this;
        }
        this.requestedKeys = new ArrayList<ContentKey>();
        return this.addAllRequestedKeys(elements);
    }

    public final DiffParamsBuilder addAllRequestedKeys(Iterable<? extends ContentKey> elements) {
        Objects.requireNonNull(elements, "requestedKeys element");
        if (this.requestedKeys == null) {
            this.requestedKeys = new ArrayList<ContentKey>();
        }
        for (ContentKey contentKey : elements) {
            this.requestedKeys.add(Objects.requireNonNull(contentKey, "requestedKeys element"));
        }
        return this;
    }

    public final DiffParamsBuilder filter(@jakarta.annotation.Nullable String filter) {
        this.filter = filter;
        return this;
    }

    public DiffParams build() {
        this.checkRequiredAttributes();
        return new DiffParams(this.fromRef, this.toRef, this.maxRecords, this.pageToken, this.minKey, this.maxKey, this.prefixKey, this.requestedKeys == null ? null : DiffParamsBuilder.createUnmodifiableList(true, this.requestedKeys), this.filter);
    }

    private boolean fromRefIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean toRefIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.fromRefIsSet()) {
            attributes.add("fromRef");
        }
        if (!this.toRefIsSet()) {
            attributes.add("toRef");
        }
        return "Cannot build DiffParams, some of required attributes are not set " + attributes;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }
}

