/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.immutables.value.Value;
import org.projectnessie.client.auth.BasicAuthenticationProvider;
import org.projectnessie.client.auth.oauth2.ImmutableOAuth2ClientParams;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;

@Value.Immutable
interface OAuth2ClientParams {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final Duration MIN_REFRESH_DELAY = Duration.ofSeconds(1L);

    public URI getTokenEndpoint();

    public String getClientId();

    public String getClientSecret();

    public Optional<String> getUsername();

    public Optional<String> getPassword();

    public Optional<String> getScope();

    @Value.Default
    default public String getGrantType() {
        return "client_credentials";
    }

    @Value.Default
    default public ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    @Value.Default
    default public Duration getDefaultAccessTokenLifespan() {
        return Duration.parse("PT1M");
    }

    @Value.Default
    default public Duration getDefaultRefreshTokenLifespan() {
        return Duration.parse("PT30M");
    }

    @Value.Default
    default public Duration getRefreshSafetyWindow() {
        return Duration.parse("PT10S");
    }

    @Value.Default
    default public boolean getTokenExchangeEnabled() {
        return true;
    }

    public Optional<ScheduledExecutorService> getExecutor();

    @Value.Default
    default public HttpClient.Builder getHttpClient() {
        HttpAuthentication authentication = BasicAuthenticationProvider.create(this.getClientId(), this.getClientSecret());
        return HttpClient.builder().setBaseUri(this.getTokenEndpoint()).setObjectMapper(this.getObjectMapper()).setAuthentication(authentication).setDisableCompression(true);
    }

    @Value.Check
    default public void check() {
        if (this.getClientId().isEmpty()) {
            throw new IllegalArgumentException("client ID must not be empty");
        }
        if (this.getClientSecret().isEmpty()) {
            throw new IllegalArgumentException("client secret must not be empty");
        }
        if (!this.getGrantType().equals("client_credentials") && !this.getGrantType().equals("password")) {
            throw new IllegalArgumentException(String.format("grant type must be either '%s' or '%s'", "client_credentials", "password"));
        }
        if (this.getGrantType().equals("password")) {
            if (!this.getUsername().isPresent() || this.getUsername().get().isEmpty()) {
                throw new IllegalArgumentException(String.format("username must be set if grant type is '%s'", "password"));
            }
            if (!this.getPassword().isPresent() || this.getPassword().get().isEmpty()) {
                throw new IllegalArgumentException(String.format("password must be set if grant type is '%s'", "password"));
            }
        }
        if (this.getDefaultAccessTokenLifespan().compareTo(MIN_REFRESH_DELAY) < 0) {
            throw new IllegalArgumentException(String.format("default token lifespan must be greater than or equal to %s", MIN_REFRESH_DELAY));
        }
        if (this.getRefreshSafetyWindow().compareTo(MIN_REFRESH_DELAY) < 0) {
            throw new IllegalArgumentException(String.format("refresh safety window must be greater than or equal to %s", MIN_REFRESH_DELAY));
        }
        if (this.getRefreshSafetyWindow().compareTo(this.getDefaultAccessTokenLifespan()) >= 0) {
            throw new IllegalArgumentException("refresh safety window must be less than the default token lifespan");
        }
    }

    public static ImmutableOAuth2ClientParams.Builder builder() {
        return ImmutableOAuth2ClientParams.builder();
    }

    public static OAuth2ClientParams fromConfig(Function<String, String> config) {
        Objects.requireNonNull(config, "config must not be null");
        return ImmutableOAuth2ClientParams.builder().tokenEndpoint(URI.create(Objects.requireNonNull(config.apply("nessie.authentication.oauth2.token-endpoint"), "token endpoint must not be null"))).clientId(Objects.requireNonNull(config.apply("nessie.authentication.oauth2.client-id"), "client ID must not be null")).clientSecret(Objects.requireNonNull(config.apply("nessie.authentication.oauth2.client-secret"), "client secret must not be null")).username(Optional.ofNullable(config.apply("nessie.authentication.oauth2.username"))).password(Optional.ofNullable(config.apply("nessie.authentication.oauth2.password"))).grantType(Optional.ofNullable(config.apply("nessie.authentication.oauth2.grant-type")).orElse("client_credentials")).scope(Optional.ofNullable(config.apply("nessie.authentication.oauth2.client-scopes"))).defaultAccessTokenLifespan(Duration.parse(Optional.ofNullable(config.apply("nessie.authentication.oauth2.default-access-token-lifespan")).orElse("PT1M"))).defaultRefreshTokenLifespan(Duration.parse(Optional.ofNullable(config.apply("nessie.authentication.oauth2.default-refresh-token-lifespan")).orElse("PT30M"))).refreshSafetyWindow(Duration.parse(Optional.ofNullable(config.apply("nessie.authentication.oauth2.refresh-safety-window")).orElse("PT10S"))).tokenExchangeEnabled(Optional.ofNullable(config.apply("nessie.authentication.oauth2.token-exchange-enabled")).map(Boolean::parseBoolean).orElse(true)).build();
    }
}

