/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.io.airlift.compress.lz4;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iceberg.shaded.io.airlift.compress.Compressor;
import org.apache.iceberg.shaded.io.airlift.compress.lz4.Lz4RawCompressor;
import org.apache.iceberg.shaded.io.airlift.compress.lz4.UnsafeUtil;
import sun.misc.Unsafe;

public class Lz4Compressor
implements Compressor {
    private final int[] table = new int[4096];

    @Override
    public int maxCompressedLength(int uncompressedSize) {
        return Lz4RawCompressor.maxCompressedLength(uncompressedSize);
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        Lz4Compressor.verifyRange(input, inputOffset, inputLength);
        Lz4Compressor.verifyRange(output, outputOffset, maxOutputLength);
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        return Lz4RawCompressor.compress(input, inputAddress, inputLength, output, outputAddress, maxOutputLength, this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compress(ByteBuffer inputBuffer, ByteBuffer outputBuffer) {
        long outputLimit;
        long outputAddress;
        Object outputBase;
        long inputLimit;
        long inputAddress;
        Object inputBase;
        ByteBuffer input = inputBuffer;
        ByteBuffer output = outputBuffer;
        if (((Buffer)input).isDirect()) {
            inputBase = null;
            long address = UnsafeUtil.getAddress(input);
            inputAddress = address + (long)input.position();
            inputLimit = address + (long)input.limit();
        } else if (((Buffer)input).hasArray()) {
            inputBase = ((Buffer)input).array();
            inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)input).arrayOffset() + input.position();
            inputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)input).arrayOffset() + input.limit();
        } else {
            throw new IllegalArgumentException("Unsupported input ByteBuffer implementation " + input.getClass().getName());
        }
        if (((Buffer)output).isDirect()) {
            outputBase = null;
            long address = UnsafeUtil.getAddress(output);
            outputAddress = address + (long)output.position();
            outputLimit = address + (long)output.limit();
        } else if (((Buffer)output).hasArray()) {
            outputBase = ((Buffer)output).array();
            outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)output).arrayOffset() + output.position();
            outputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)output).arrayOffset() + output.limit();
        } else {
            throw new IllegalArgumentException("Unsupported output ByteBuffer implementation " + output.getClass().getName());
        }
        ByteBuffer byteBuffer = input;
        synchronized (byteBuffer) {
            ByteBuffer byteBuffer2 = output;
            synchronized (byteBuffer2) {
                int written = Lz4RawCompressor.compress(inputBase, inputAddress, (int)(inputLimit - inputAddress), outputBase, outputAddress, outputLimit - outputAddress, this.table);
                ((Buffer)output).position(output.position() + written);
            }
        }
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(String.format("Invalid offset or length (%s, %s) in array of length %s", offset, length, data.length));
        }
    }
}

