/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.gcs;

import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class GCSLocation {
    private static final String SCHEME_DELIM = "://";
    private static final String PATH_DELIM = "/";
    private static final String QUERY_DELIM = "\\?";
    private static final String FRAGMENT_DELIM = "#";
    private static final String EXPECTED_SCHEME = "gs";
    private final String bucket;
    private final String prefix;

    GCSLocation(String location) {
        Preconditions.checkArgument(location != null, "Invalid location: null");
        String[] schemeSplit = location.split(SCHEME_DELIM, -1);
        ValidationException.check(schemeSplit.length == 2, "Invalid GCS URI, cannot determine scheme: %s", location);
        String scheme = schemeSplit[0];
        ValidationException.check(EXPECTED_SCHEME.equals(scheme), "Invalid GCS URI, invalid scheme: %s", scheme);
        String[] authoritySplit = schemeSplit[1].split(PATH_DELIM, 2);
        this.bucket = authoritySplit[0];
        String path = authoritySplit.length > 1 ? authoritySplit[1] : "";
        path = path.split(QUERY_DELIM, -1)[0];
        this.prefix = path = path.split(FRAGMENT_DELIM, -1)[0];
    }

    public String bucket() {
        return this.bucket;
    }

    public String prefix() {
        return this.prefix;
    }
}

