/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collection;
import java.util.Collections;
import org.apache.iceberg.EmptyStructLike;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

public class BaseScanTaskGroup<T extends ScanTask>
implements ScanTaskGroup<T> {
    private final StructLike groupingKey;
    private final Object[] tasks;
    private volatile transient Collection<T> taskCollection;

    public BaseScanTaskGroup(StructLike groupingKey, Collection<T> tasks) {
        Preconditions.checkNotNull(tasks, "tasks cannot be null");
        this.groupingKey = groupingKey;
        this.tasks = tasks.toArray();
        this.taskCollection = Collections.unmodifiableCollection(tasks);
    }

    public BaseScanTaskGroup(Collection<T> tasks) {
        this(EmptyStructLike.get(), tasks);
    }

    @Override
    public StructLike groupingKey() {
        return this.groupingKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> tasks() {
        if (this.taskCollection == null) {
            BaseScanTaskGroup baseScanTaskGroup = this;
            synchronized (baseScanTaskGroup) {
                if (this.taskCollection == null) {
                    ImmutableList.Builder listBuilder = ImmutableList.builderWithExpectedSize(this.tasks.length);
                    for (Object task : this.tasks) {
                        listBuilder.add((ScanTask)task);
                    }
                    this.taskCollection = listBuilder.build();
                }
            }
        }
        return this.taskCollection;
    }

    @Override
    public long sizeBytes() {
        long sizeBytes = 0L;
        for (Object task : this.tasks) {
            sizeBytes += ((ScanTask)task).sizeBytes();
        }
        return sizeBytes;
    }

    @Override
    public long estimatedRowsCount() {
        long estimatedRowsCount = 0L;
        for (Object task : this.tasks) {
            estimatedRowsCount += ((ScanTask)task).estimatedRowsCount();
        }
        return estimatedRowsCount;
    }

    @Override
    public int filesCount() {
        int filesCount = 0;
        for (Object task : this.tasks) {
            filesCount += ((ScanTask)task).filesCount();
        }
        return filesCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("tasks", Joiner.on(", ").join(this.tasks)).toString();
    }
}

