/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.mapred;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.iceberg.mr.InputFormatConfig;
import org.apache.iceberg.mr.mapred.AbstractMapredIcebergRecordReader;
import org.apache.iceberg.mr.mapred.Container;
import org.apache.iceberg.mr.mapreduce.IcebergInputFormat;
import org.apache.iceberg.mr.mapreduce.IcebergSplit;
import org.apache.iceberg.mr.mapreduce.IcebergSplitContainer;

public class MapredIcebergInputFormat<T>
implements InputFormat<Void, Container<T>> {
    private final IcebergInputFormat<T> innerInputFormat = new IcebergInputFormat();

    public static InputFormatConfig.ConfigBuilder configure(JobConf job) {
        job.setInputFormat(MapredIcebergInputFormat.class);
        return new InputFormatConfig.ConfigBuilder((Configuration)job);
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        return (InputSplit[])this.innerInputFormat.getSplits(MapredIcebergInputFormat.newJobContext(job)).stream().map(InputSplit.class::cast).toArray(InputSplit[]::new);
    }

    public RecordReader<Void, Container<T>> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        IcebergSplit icebergSplit = ((IcebergSplitContainer)split).icebergSplit();
        return new MapredIcebergRecordReader<T>(this.innerInputFormat, icebergSplit, job, reporter);
    }

    private static JobContext newJobContext(JobConf job) {
        JobID jobID = Optional.ofNullable(JobID.forName((String)job.get("mapreduce.job.id"))).orElseGet(JobID::new);
        return new JobContextImpl((Configuration)job, jobID);
    }

    public static TaskAttemptContext newTaskAttemptContext(JobConf job, Reporter reporter) {
        TaskAttemptID taskAttemptID = Optional.ofNullable(TaskAttemptID.forName((String)job.get("mapreduce.task.attempt.id"))).orElseGet(TaskAttemptID::new);
        return new CompatibilityTaskAttemptContextImpl((Configuration)job, taskAttemptID, reporter);
    }

    private static StatusReporter toStatusReporter(final Reporter reporter) {
        return new StatusReporter(){

            public Counter getCounter(Enum<?> name) {
                return reporter.getCounter(name);
            }

            public Counter getCounter(String group, String name) {
                return reporter.getCounter(group, name);
            }

            public void progress() {
                reporter.progress();
            }

            public float getProgress() {
                return reporter.getProgress();
            }

            public void setStatus(String status) {
                reporter.setStatus(status);
            }
        };
    }

    public static class CompatibilityTaskAttemptContextImpl
    extends TaskAttemptContextImpl {
        private final Reporter legacyReporter;

        public CompatibilityTaskAttemptContextImpl(Configuration conf, TaskAttemptID taskId, Reporter reporter) {
            super(conf, taskId, MapredIcebergInputFormat.toStatusReporter(reporter));
            this.legacyReporter = reporter;
        }

        public Reporter getLegacyReporter() {
            return this.legacyReporter;
        }
    }

    private static final class MapredIcebergRecordReader<T>
    extends AbstractMapredIcebergRecordReader<Container<T>> {
        private final long splitLength;

        MapredIcebergRecordReader(IcebergInputFormat<T> mapreduceInputFormat, IcebergSplit split, JobConf job, Reporter reporter) throws IOException {
            super(mapreduceInputFormat, split, job, reporter);
            this.splitLength = split.getLength();
        }

        public boolean next(Void key, Container<T> value) throws IOException {
            try {
                if (this.innerReader.nextKeyValue()) {
                    value.set(this.innerReader.getCurrentValue());
                    return true;
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
            return false;
        }

        public Container<T> createValue() {
            return new Container();
        }

        public long getPos() throws IOException {
            return (long)((float)this.splitLength * this.getProgress());
        }
    }
}

