/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure.adlsv2;

import com.azure.storage.file.datalake.DataLakeFileClient;
import org.apache.iceberg.azure.AzureProperties;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

abstract class BaseADLSFile {
    private final String location;
    private final DataLakeFileClient fileClient;
    private final AzureProperties azureProperties;
    private final MetricsContext metrics;

    BaseADLSFile(String location, DataLakeFileClient fileClient, AzureProperties azureProperties, MetricsContext metrics) {
        Preconditions.checkArgument(location != null, "Cannot initialize ADLS file with null location");
        Preconditions.checkArgument(fileClient != null, "Cannot initialize ADLS file with null file client");
        Preconditions.checkArgument(azureProperties != null, "Cannot initialize ADLS file with null properties");
        Preconditions.checkArgument(metrics != null, "Cannot initialize ADLS file with null metrics");
        this.location = location;
        this.fileClient = fileClient;
        this.azureProperties = azureProperties;
        this.metrics = metrics;
    }

    protected AzureProperties azureProperties() {
        return this.azureProperties;
    }

    protected MetricsContext metrics() {
        return this.metrics;
    }

    protected DataLakeFileClient fileClient() {
        return this.fileClient;
    }

    public String location() {
        return this.location;
    }

    public boolean exists() {
        return this.fileClient().exists();
    }

    public String toString() {
        return this.location;
    }
}

