/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonView;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Generated;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ser.Views;

@ParametersAreNonnullByDefault
@Generated(from="GetMultipleContentsResponse", generator="Immutables")
@Immutable
public final class ImmutableGetMultipleContentsResponse
implements GetMultipleContentsResponse {
    private final List<GetMultipleContentsResponse.ContentWithKey> contents;
    private final Reference effectiveReference;

    private ImmutableGetMultipleContentsResponse(Iterable<? extends GetMultipleContentsResponse.ContentWithKey> contents, Reference effectiveReference) {
        this.contents = ImmutableGetMultipleContentsResponse.createUnmodifiableList(false, ImmutableGetMultipleContentsResponse.createSafeList(contents, true, false));
        this.effectiveReference = effectiveReference;
    }

    private ImmutableGetMultipleContentsResponse(ImmutableGetMultipleContentsResponse original, List<GetMultipleContentsResponse.ContentWithKey> contents, Reference effectiveReference) {
        this.contents = contents;
        this.effectiveReference = effectiveReference;
    }

    @Override
    @JsonProperty(value="contents")
    public List<GetMultipleContentsResponse.ContentWithKey> getContents() {
        return this.contents;
    }

    @Override
    @JsonProperty(value="effectiveReference")
    @JsonView(value={Views.V2.class})
    public Reference getEffectiveReference() {
        return this.effectiveReference;
    }

    public final ImmutableGetMultipleContentsResponse withContents(GetMultipleContentsResponse.ContentWithKey ... elements) {
        List<GetMultipleContentsResponse.ContentWithKey> newValue = ImmutableGetMultipleContentsResponse.createUnmodifiableList(false, ImmutableGetMultipleContentsResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGetMultipleContentsResponse(this, newValue, this.effectiveReference);
    }

    public final ImmutableGetMultipleContentsResponse withContents(Iterable<? extends GetMultipleContentsResponse.ContentWithKey> elements) {
        if (this.contents == elements) {
            return this;
        }
        List<GetMultipleContentsResponse.ContentWithKey> newValue = ImmutableGetMultipleContentsResponse.createUnmodifiableList(false, ImmutableGetMultipleContentsResponse.createSafeList(elements, true, false));
        return new ImmutableGetMultipleContentsResponse(this, newValue, this.effectiveReference);
    }

    public final ImmutableGetMultipleContentsResponse withEffectiveReference(Reference value) {
        if (this.effectiveReference == value) {
            return this;
        }
        return new ImmutableGetMultipleContentsResponse(this, this.contents, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetMultipleContentsResponse && this.equalTo(0, (ImmutableGetMultipleContentsResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetMultipleContentsResponse another) {
        return this.contents.equals(another.contents) && Objects.equals(this.effectiveReference, another.effectiveReference);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.contents.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.effectiveReference);
        return h2;
    }

    public String toString() {
        return "GetMultipleContentsResponse{contents=" + this.contents + ", effectiveReference=" + this.effectiveReference + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGetMultipleContentsResponse fromJson(Json json) {
        Builder builder = ImmutableGetMultipleContentsResponse.builder();
        if (json.contents != null) {
            builder.addAllContents(json.contents);
        }
        if (json.effectiveReference != null) {
            builder.effectiveReference(json.effectiveReference);
        }
        return builder.build();
    }

    public static ImmutableGetMultipleContentsResponse of(List<GetMultipleContentsResponse.ContentWithKey> contents, Reference effectiveReference) {
        return ImmutableGetMultipleContentsResponse.of(contents, effectiveReference);
    }

    public static ImmutableGetMultipleContentsResponse of(Iterable<? extends GetMultipleContentsResponse.ContentWithKey> contents, Reference effectiveReference) {
        return new ImmutableGetMultipleContentsResponse(contents, effectiveReference);
    }

    public static ImmutableGetMultipleContentsResponse copyOf(GetMultipleContentsResponse instance) {
        if (instance instanceof ImmutableGetMultipleContentsResponse) {
            return (ImmutableGetMultipleContentsResponse)instance;
        }
        return ImmutableGetMultipleContentsResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GetMultipleContentsResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<GetMultipleContentsResponse.ContentWithKey> contents = new ArrayList<GetMultipleContentsResponse.ContentWithKey>();
        @Nullable
        private Reference effectiveReference;

        private Builder() {
        }

        public final Builder from(GetMultipleContentsResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllContents(instance.getContents());
            Reference effectiveReferenceValue = instance.getEffectiveReference();
            if (effectiveReferenceValue != null) {
                this.effectiveReference(effectiveReferenceValue);
            }
            return this;
        }

        public final Builder addContents(GetMultipleContentsResponse.ContentWithKey element) {
            this.contents.add(Objects.requireNonNull(element, "contents element"));
            return this;
        }

        public final Builder addContents(GetMultipleContentsResponse.ContentWithKey ... elements) {
            for (GetMultipleContentsResponse.ContentWithKey element : elements) {
                this.contents.add(Objects.requireNonNull(element, "contents element"));
            }
            return this;
        }

        @JsonProperty(value="contents")
        public final Builder contents(Iterable<? extends GetMultipleContentsResponse.ContentWithKey> elements) {
            this.contents.clear();
            return this.addAllContents(elements);
        }

        public final Builder addAllContents(Iterable<? extends GetMultipleContentsResponse.ContentWithKey> elements) {
            for (GetMultipleContentsResponse.ContentWithKey contentWithKey : elements) {
                this.contents.add(Objects.requireNonNull(contentWithKey, "contents element"));
            }
            return this;
        }

        @JsonProperty(value="effectiveReference")
        @JsonView(value={Views.V2.class})
        public final Builder effectiveReference(Reference effectiveReference) {
            this.effectiveReference = effectiveReference;
            return this;
        }

        public ImmutableGetMultipleContentsResponse build() {
            return new ImmutableGetMultipleContentsResponse(null, ImmutableGetMultipleContentsResponse.createUnmodifiableList(true, this.contents), this.effectiveReference);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GetMultipleContentsResponse", generator="Immutables")
    static final class Json
    implements GetMultipleContentsResponse {
        @Nullable
        List<GetMultipleContentsResponse.ContentWithKey> contents = Collections.emptyList();
        @Nullable
        Reference effectiveReference;

        Json() {
        }

        @JsonProperty(value="contents")
        public void setContents(List<GetMultipleContentsResponse.ContentWithKey> contents) {
            this.contents = contents;
        }

        @JsonProperty(value="effectiveReference")
        @JsonView(value={Views.V2.class})
        public void setEffectiveReference(Reference effectiveReference) {
            this.effectiveReference = effectiveReference;
        }

        @Override
        public List<GetMultipleContentsResponse.ContentWithKey> getContents() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference getEffectiveReference() {
            throw new UnsupportedOperationException();
        }
    }
}

