/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.io.IOException;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.immutables.value.Value;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableConflict;

@JsonSerialize(as=ImmutableConflict.class)
@JsonDeserialize(as=ImmutableConflict.class)
@Value.Immutable
public interface Conflict {
    @Nullable
    @JsonDeserialize(using=ConflictType.Deserializer.class)
    @Value.Parameter(order=1)
    public ConflictType conflictType();

    @Nullable
    @Value.Parameter(order=2)
    public ContentKey key();

    @Value.Parameter(order=3)
    public String message();

    public static Conflict conflict(@Nullable ConflictType conflictType, @Nullable ContentKey key, String message) {
        return ImmutableConflict.of(conflictType, key, message);
    }

    public static enum ConflictType {
        UNKNOWN,
        KEY_EXISTS,
        KEY_DOES_NOT_EXIST,
        PAYLOAD_DIFFERS,
        CONTENT_ID_DIFFERS,
        VALUE_DIFFERS,
        NAMESPACE_ABSENT,
        NOT_A_NAMESPACE,
        NAMESPACE_NOT_EMPTY,
        UNEXPECTED_HASH,
        KEY_CONFLICT,
        DOCUMENTATION_DIFFERS;


        public static ConflictType parse(String conflictType) {
            try {
                if (conflictType != null) {
                    return ConflictType.valueOf(conflictType.toUpperCase(Locale.ROOT));
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public static final class Deserializer
        extends JsonDeserializer<ConflictType> {
            @Override
            public ConflictType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String name = p.readValueAs(String.class);
                return name != null ? ConflictType.parse(name) : null;
            }
        }
    }
}

