/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.NessieApiCompatibilityException;

public class NessieApiCompatibility {
    private static final String MIN_API_VERSION = "minSupportedApiVersion";
    private static final String MAX_API_VERSION = "maxSupportedApiVersion";
    private static final String ACTUAL_API_VERSION = "actualApiVersion";

    public static void check(int clientApiVersion, HttpClient httpClient) throws NessieApiCompatibilityException {
        int actualServerApiVersion;
        JsonNode config = httpClient.newRequest().path("config").get().readEntity(JsonNode.class);
        int minServerApiVersion = config.hasNonNull(MIN_API_VERSION) ? config.get(MIN_API_VERSION).asInt() : 1;
        int maxServerApiVersion = config.get(MAX_API_VERSION).asInt();
        int n = actualServerApiVersion = config.hasNonNull(ACTUAL_API_VERSION) ? config.get(ACTUAL_API_VERSION).asInt() : 0;
        if (clientApiVersion < minServerApiVersion || clientApiVersion > maxServerApiVersion || actualServerApiVersion > 0 && clientApiVersion != actualServerApiVersion) {
            throw new NessieApiCompatibilityException(clientApiVersion, minServerApiVersion, maxServerApiVersion, actualServerApiVersion);
        }
    }
}

